/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.oracle;

import org.aksw.limes.core.evaluation.oracle.IOracle;
import org.aksw.limes.core.evaluation.oracle.SimpleOracle;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.reader.AMappingReader;
import org.aksw.limes.core.io.mapping.reader.CSVMappingReader;
import org.aksw.limes.core.io.mapping.reader.RDFMappingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleFactory {
    static Logger logger = LoggerFactory.getLogger(OracleFactory.class);

    public static IOracle getOracle(String filePath, String inputType, String oracleType) {
        AMappingReader reader = null;
        System.out.println("Getting reader of type " + inputType);
        if (inputType.equalsIgnoreCase("csv")) {
            reader = new CSVMappingReader(filePath);
        } else if (inputType.equalsIgnoreCase("rdf")) {
            reader = new RDFMappingReader(filePath);
        } else if (inputType.equalsIgnoreCase("tab")) {
            reader = new CSVMappingReader(filePath);
            ((CSVMappingReader)reader).setDelimiter("\t");
        } else {
            reader = new CSVMappingReader(filePath);
        }
        AMapping m = reader.read();
        SimpleOracle oracle = oracleType.equals("simple") ? new SimpleOracle(m) : new SimpleOracle(m);
        return oracle;
    }
}

