/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;

public class LimesResult {
    protected AMapping verificationMapping;
    protected AMapping acceptanceMapping;
    private ACache sourceCache = null;
    private ACache targetCache = null;
    private long runTime = 0L;

    LimesResult() {
        this.verificationMapping = MappingFactory.createDefaultMapping();
        this.acceptanceMapping = MappingFactory.createDefaultMapping();
    }

    public LimesResult(AMapping verificationMapping, AMapping acceptanceMapping) {
        this.verificationMapping = verificationMapping;
        this.acceptanceMapping = acceptanceMapping;
    }

    public LimesResult(AMapping verificationMapping, AMapping acceptanceMapping, ACache sourceCache, ACache targetCache, long runTime) {
        this(verificationMapping, acceptanceMapping);
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
        this.runTime = runTime;
    }

    public AMapping getVerificationMapping() {
        return this.verificationMapping;
    }

    public AMapping getAcceptanceMapping() {
        return this.acceptanceMapping;
    }

    public String getStatistics() {
        if (this.sourceCache == null) {
            return "";
        }
        GoldStandard goldStandard = new GoldStandard(null, this.sourceCache, this.targetCache);
        double pseudoPrecisionForAcceptance = new PseudoFMeasure().precision(this.acceptanceMapping, goldStandard);
        double pseudoRecallForAcceptance = new PseudoFMeasure().recall(this.acceptanceMapping, goldStandard);
        double pseudoFMeasureForAcceptance = new PseudoFMeasure().calculate(this.acceptanceMapping, goldStandard);
        AMapping wholeMapping = MappingOperations.union(this.acceptanceMapping, this.verificationMapping);
        double pseudoPrecisionForAll = new PseudoFMeasure().precision(wholeMapping, goldStandard);
        double pseudoRecallForAll = new PseudoFMeasure().recall(wholeMapping, goldStandard);
        double pseudoFMeasureForAll = new PseudoFMeasure().calculate(wholeMapping, goldStandard);
        return String.format("{\n\t\"mappingTime\" : %d,\n\t\"inputSizes\" : {\n\t\t\"source\" : %d,\n\t\t\"target\" : %d\n\t},\n\t\"outputSizes\" : {\n\t\t\"verification\" : %d,\n\t\t\"acceptance\" : %d\n\t},\n\t\"pseudoPRF\" : {\n\t\t\"acceptance\" : {\n\t\t\t\"precision\" : %s,\n\t\t\t\"recall\" : %s,\n\t\t\t\"f-measure\" : %s\n\t\t},\n\t\t\"all\" : {\n\t\t\t\"precision\" : %s,\n\t\t\t\"recall\" : %s,\n\t\t\t\"f-measure\" : %s\n\t\t}\n\t}\n}", this.runTime, this.sourceCache.size(), this.targetCache.size(), this.verificationMapping.size(), this.acceptanceMapping.size(), Double.toString(pseudoPrecisionForAcceptance), Double.toString(pseudoRecallForAcceptance), Double.toString(pseudoFMeasureForAcceptance), Double.toString(pseudoPrecisionForAll), Double.toString(pseudoRecallForAll), Double.toString(pseudoFMeasureForAll));
    }

    private AMapping filterReferenceCompliant(AMapping input, Set<String> referenceS, Set<String> referenceT) {
        AMapping filtered = MappingFactory.createDefaultMapping();
        for (String s : input.getMap().keySet()) {
            if (!referenceS.contains(s)) continue;
            for (String t : input.getMap().get(s).keySet()) {
                if (!referenceT.contains(t)) continue;
                filtered.add(s, t, input.getConfidence(s, t));
            }
        }
        return filtered;
    }

    public String getStatistics(AMapping reference) {
        String stats = this.getStatistics();
        stats = stats.substring(0, stats.length() - 2);
        Set<String> gsS = reference.getMap().keySet();
        HashSet<String> gsT = new HashSet<String>();
        for (String s : reference.getMap().keySet()) {
            gsT.addAll(reference.getMap().get(s).keySet());
        }
        GoldStandard goldStandard = new GoldStandard(reference, this.sourceCache, this.targetCache);
        AMapping filteredAcceptance = this.filterReferenceCompliant(this.acceptanceMapping, gsS, gsT);
        double precisionForAcceptance = new FMeasure().precision(filteredAcceptance, goldStandard);
        double recallForAcceptance = new FMeasure().recall(filteredAcceptance, goldStandard);
        double fMeasureForAcceptance = new FMeasure().calculate(filteredAcceptance, goldStandard);
        AMapping filteredWhole = MappingOperations.union(filteredAcceptance, this.filterReferenceCompliant(this.verificationMapping, gsS, gsT));
        double precisionForAll = new FMeasure().precision(filteredWhole, goldStandard);
        double recallForAll = new FMeasure().recall(filteredWhole, goldStandard);
        double fMeasureForAll = new FMeasure().calculate(filteredWhole, goldStandard);
        return stats + String.format(",\n\t\"PRF\" : {\n\t\t\"acceptance\" : {\n\t\t\t\"precision\" : %s,\n\t\t\t\"recall\" : %s,\n\t\t\t\"f-measure\" : %s\n\t\t},\n\t\t\"all\" : {\n\t\t\t\"precision\" : %s,\n\t\t\t\"recall\" : %s,\n\t\t\t\"f-measure\" : %s\n\t\t}\n\t}\n}", Double.toString(precisionForAcceptance), Double.toString(recallForAcceptance), Double.toString(fMeasureForAcceptance), Double.toString(precisionForAll), Double.toString(recallForAll), Double.toString(fMeasureForAll));
    }

    public void forceOneToOneMapping() {
        AMapping map = MappingFactory.createDefaultMapping();
        this.verificationMapping = map.getBestOneToOneMappings(this.verificationMapping);
        this.acceptanceMapping = map.getBestOneToOneMappings(this.acceptanceMapping);
    }
}

