/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;

public class ActiveLearningExamples
implements Iterable<Example> {
    private AMapping exampleMap;
    private ACache sourceCache;
    private ACache targetCache;

    public ActiveLearningExamples(AMapping exampleMap, ACache sourceCache, ACache targetCache) {
        this.exampleMap = exampleMap;
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
    }

    @Override
    public Iterator<Example> iterator() {
        return new ExampleIterator();
    }

    public AMapping getExampleMap() {
        return this.exampleMap;
    }

    public class ExampleIterator
    implements Iterator<Example> {
        Map<String, Map<String, Double>> map;
        private Iterator<String> sourceIt;
        private Iterator<String> targetIt;
        private String source;

        private ExampleIterator() {
            HashMap<String, HashMap<String, Double>> ogMap = ActiveLearningExamples.this.exampleMap.getMap();
            this.map = new LinkedHashMap<String, Map<String, Double>>(ogMap.size(), 1.0f);
            ogMap.forEach((s, sMap) -> {
                this.map.put((String)s, new LinkedHashMap(sMap.size(), 1.0f));
                sMap.forEach((t, score) -> this.map.get(s).put((String)t, (Double)score));
            });
            this.sourceIt = this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.sourceIt.hasNext() || this.targetIt != null && this.targetIt.hasNext();
        }

        @Override
        public Example next() {
            if (this.source == null) {
                if (this.sourceIt.hasNext()) {
                    this.source = this.sourceIt.next();
                    this.targetIt = this.map.get(this.source).keySet().iterator();
                } else {
                    throw new NoSuchElementException();
                }
            }
            while (!this.targetIt.hasNext()) {
                if (!this.sourceIt.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.source = this.sourceIt.next();
                this.targetIt = this.map.get(this.source).keySet().iterator();
            }
            return new Example(this.source, this.targetIt.next());
        }
    }

    public class Example {
        private Instance source;
        private Instance target;

        public Example(String source, String target) {
            this.source = ActiveLearningExamples.this.sourceCache.getInstance(source);
            this.target = ActiveLearningExamples.this.targetCache.getInstance(target);
        }

        public Instance getSource() {
            return this.source;
        }

        public Instance getTarget() {
            return this.target;
        }

        public void classify(double score) {
            if (ActiveLearningExamples.this.exampleMap.contains(this.source.getUri(), this.target.getUri())) {
                ActiveLearningExamples.this.exampleMap.getMap().get(this.source.getUri()).put(this.target.getUri(), score);
            }
        }
    }
}

