/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.wombat;

import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.ml.algorithm.wombat.RefinementNode;

public class ExtendedRefinementNode
extends RefinementNode {
    private double maxFMeasure = 1.0;

    public ExtendedRefinementNode() {
        super(-1.7976931348623157E308, MappingFactory.createDefaultMapping(), "");
    }

    public ExtendedRefinementNode(double fMeasure, AMapping map, String metricExpression) {
        super(fMeasure, map, metricExpression);
    }

    public ExtendedRefinementNode(double fMeasure, AMapping map, String metricExpression, AMapping refMap, double beta, double rMax) {
        super(fMeasure, map, metricExpression);
        double pMax = this.computeMaxPrecision(map, refMap);
        this.maxFMeasure = (1.0 + Math.pow(beta, 2.0)) * pMax * rMax / (Math.pow(beta, 2.0) * pMax + rMax);
    }

    private double computeMaxPrecision(AMapping map, AMapping refMap) {
        AMapping falsePos = MappingFactory.createDefaultMapping();
        for (String key : map.getMap().keySet()) {
            for (String value : map.getMap().get(key).keySet()) {
                if (!refMap.getMap().containsKey(key) && !refMap.getReversedMap().containsKey(value)) continue;
                falsePos.add(key, value, map.getMap().get(key).get(value));
            }
        }
        AMapping m = MappingOperations.difference(falsePos, refMap);
        return (double)refMap.size() / (double)(refMap.size() + m.size());
    }

    public double getMaxFMeasure() {
        return this.maxFMeasure;
    }

    public void setMaxFMeasure(double maxFMeasure) {
        this.maxFMeasure = maxFMeasure;
    }
}

