/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching;

import java.util.HashMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.matching.PropertyMapper;
import org.aksw.limes.core.ml.algorithm.matching.stablematching.HospitalResidents;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyMapper
implements PropertyMapper {
    public int LIMIT = 500;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public int MINSIM = 1;
    Model sourceModel;
    Model targetModel;

    public DefaultPropertyMapper() {
    }

    public DefaultPropertyMapper(Model sourceModel, Model targetModel) {
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    @Override
    public AMapping getPropertyMapping(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        AMapping m = this.getMappingProperties(endpoint1, endpoint2, classExpression1, classExpression2);
        HospitalResidents hr = new HospitalResidents();
        m = hr.getMatching(m);
        AMapping copy = MappingFactory.createDefaultMapping();
        for (String s : m.getMap().keySet()) {
            for (String t : m.getMap().get(s).keySet()) {
                if (!(m.getConfidence(s, t) >= (double)this.MINSIM)) continue;
                copy.add(s, t, m.getConfidence(s, t));
            }
        }
        return copy;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    @Override
    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    @Override
    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public AMapping getMappingProperties(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        this.logger.info("Getting mapping from " + classExpression1 + " to " + classExpression2);
        AMapping m2 = this.getMonoDirectionalMap(endpoint1, endpoint2, classExpression1, classExpression2);
        this.logger.debug("m2=" + m2.size());
        this.logger.info("Getting mapping from " + classExpression2 + " to " + classExpression1);
        AMapping m1 = this.getMonoDirectionalMap(endpoint2, endpoint1, classExpression2, classExpression1);
        this.logger.debug("m1=" + m1.size());
        this.logger.debug("Merging the mappings...");
        for (String key : m1.getMap().keySet()) {
            for (String value : m1.getMap().get(key).keySet()) {
                double sim2 = m2.getConfidence(value, key);
                double sim1 = m1.getConfidence(key, value);
                m2.add(value, key, sim1 + sim2);
            }
        }
        this.logger.debug("Property mapping is \n" + m2);
        return m2;
    }

    public AMapping getMonoDirectionalMap(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        String p;
        HashMap propertyValueMap = new HashMap();
        AMapping propertyToProperty = MappingFactory.createDefaultMapping();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?s ?p ?o \nWHERE { ?s rdf:type <" + classExpression1 + "> . \n?s ?p ?o . \n}";
        if (this.LIMIT > 0) {
            query = query + " LIMIT " + this.LIMIT;
        }
        this.logger.debug("Query:\n" + query);
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        int count = 0;
        while (results.hasNext()) {
            ++count;
            QuerySolution soln = results.nextSolution();
            try {
                String s = soln.get("s").toString();
                p = soln.get("p").toString();
                String o = soln.get("o").toString();
                if (DefaultPropertyMapper.isNumeric(o)) continue;
                if (!propertyValueMap.containsKey(p)) {
                    propertyValueMap.put(p, new TreeSet());
                }
                ((TreeSet)propertyValueMap.get(p)).add(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.debug("Had " + count + "results");
        for (String property : propertyValueMap.keySet()) {
            for (String object : (TreeSet)propertyValueMap.get(property)) {
                if ((object = object.split("@")[0]).contains("\\") || object.contains("\n") || object.contains("\"")) continue;
                String objectString = !object.startsWith("http") ? "\"" + object.replaceAll(" ", "_") + "\"" : "<" + object.replaceAll(" ", "_") + ">";
                query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?p WHERE { ?s rdf:type <" + classExpression2 + "> . ?s ?p " + objectString + "}LIMIT 50";
                this.logger.debug(query);
                sparqlQuery = QueryFactory.create((String)query);
                qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
                results = qexec.execSelect();
                int count2 = 0;
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    ++count2;
                    try {
                        p = soln.get("p").toString();
                        double sim = propertyToProperty.getConfidence(property, p);
                        if (sim > 0.0) {
                            propertyToProperty.getMap().get(property).put(p, sim + 1.0);
                            continue;
                        }
                        propertyToProperty.add(property, p, 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.logger.debug("lead to " + count2 + " results");
            }
        }
        return propertyToProperty;
    }

    public static boolean isNumeric(String input) {
        if (input.contains("^^")) {
            input = input.split("^^")[0];
        }
        if (input.contains("%")) {
            input = input.split("\\%")[0];
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

