/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.List;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.classifier.ComplexClassifier;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.BooleanEuclid;
import org.aksw.limes.core.ml.algorithm.euclid.LinearSelfConfigurator;
import org.aksw.limes.core.ml.algorithm.euclid.MeshBasedSelfConfigurator;
import org.apache.log4j.Logger;

public class MeshEuclid
extends BooleanEuclid {
    protected static Logger logger = Logger.getLogger(MeshEuclid.class);
    public static final String ALGORITHM_NAME = "euclid mesh";
    public static final String GRID_POINTS = "grid_points";

    @Override
    protected void init(List<LearningParameter> learningParameters, ACache sourceCache, ACache targetCache) {
        this.setDefaultParameters();
        super.init(learningParameters, sourceCache, targetCache);
        this.lsc = new MeshBasedSelfConfigurator(sourceCache, targetCache);
    }

    @Override
    public void setDefaultParameters() {
        int grid_points = 5;
        super.setDefaultParameters();
        this.learningParameters.add(new LearningParameter(GRID_POINTS, grid_points, Integer.class, 0.0, 1.0, 1.0, GRID_POINTS));
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) throws UnsupportedMLImplementationException {
        MeshBasedSelfConfigurator lsc = new MeshBasedSelfConfigurator(this.sourceCache, this.targetCache);
        this.configureEuclid(lsc);
        lsc.setPFMType(LinearSelfConfigurator.QMeasureType.UNSUPERVISED);
        List<SimpleClassifier> init_classifiers = lsc.getBestInitialClassifiers();
        logger.info((Object)("Initial classifiers: " + init_classifiers.size()));
        ComplexClassifier complex = lsc.getZoomedHillTop((int)((Integer)this.getParameter("max_iterations")), (Integer)this.getParameter(GRID_POINTS), init_classifiers);
        MLResults result = new MLResults();
        AMapping mapping = lsc.getMapping(complex.getClassifiers());
        result.setMapping(complex.getMapping());
        result.setQuality(lsc.computeQuality(mapping));
        result.setLinkSpecification(lsc.getLinkSpecification(complex.getClassifiers()));
        result.setClassifiers(complex.getClassifiers());
        for (int i = 0; i < complex.getClassifiers().size(); ++i) {
            result.addDetail(i + ". Classifier ", complex.getClassifiers().get(i));
            AMapping map = lsc.executeClassifier(complex.getClassifiers().get(i), complex.getClassifiers().get(i).getThreshold());
            result.addDetail(i + ". Mapping.size= ", map.size());
        }
        return result;
    }

    @Override
    protected String getName() {
        return ALGORITHM_NAME;
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        assert (mlModel.classifiersSet());
        List<SimpleClassifier> classifiers = mlModel.getClassifiers();
        assert (classifiers.size() > 0);
        MeshBasedSelfConfigurator le = new MeshBasedSelfConfigurator(source, target);
        this.configureEuclid(le);
        AMapping map = le.getMapping(classifiers);
        logger.info((Object)("Should predict with mlModel on Caches +" + source.size() + "," + target.size() + "+ resulted in " + map.size() + " map."));
        return map;
    }
}

