/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.LinearSelfConfigurator;

public class LinearEuclid
extends ACoreMLAlgorithm {
    protected static final String ALGORITHM_NAME = "euclid linear";
    public static final String STRICT = "strict";
    public static final String ITERATIONS_MAX = "max_iterations";
    public static final String MIN_THRESHOLD = "min_threshold";
    public static final String KAPPA = "kappa";
    public static final String BETA = "beta";
    public static final String LEARNING_RATE = "learning_rate";
    public static final String MIN_COVERAGE = "min_coverage";
    protected LinearSelfConfigurator lsc = null;

    @Override
    protected void init(List<LearningParameter> learningParameters, ACache sourceCache, ACache targetCache) {
        this.setDefaultParameters();
        super.init(learningParameters, sourceCache, targetCache);
        this.lsc = new LinearSelfConfigurator(sourceCache, targetCache);
    }

    @Override
    protected String getName() {
        return ALGORITHM_NAME;
    }

    @Override
    public void setDefaultParameters() {
        this.learningParameters = new ArrayList();
        this.learningParameters.add(new LearningParameter(ITERATIONS_MAX, 5, Integer.class, 1.0, 2.147483647E9, 1.0, "Maximal number of iterations EUCLID tries to refine its results."));
        this.learningParameters.add(new LearningParameter(BETA, 1.0, Double.class, 0.0, 1.0, Double.NaN, "Shifts F-Measures towards precision or recall"));
        this.learningParameters.add(new LearningParameter(STRICT, true, Boolean.class, -1.0, 1.0, 2.0, STRICT));
        this.learningParameters.add(new LearningParameter(MIN_THRESHOLD, 0.1, Double.class, 0.0, 1.0, Double.NaN, MIN_THRESHOLD));
        this.learningParameters.add(new LearningParameter(KAPPA, 0.8, Double.class, 0.0, 1.0, Double.NaN, KAPPA));
        this.learningParameters.add(new LearningParameter(LEARNING_RATE, 0.125, Double.class, 0.0, 1.0, Double.NaN, "Step range of each LSs treshold"));
        this.learningParameters.add(new LearningParameter(MIN_COVERAGE, 0.9, Double.class, 0.0, 1.0, Double.NaN, "Coverage percentage of a property over all instances"));
    }

    protected MLResults learn() {
        List<SimpleClassifier> init_classifiers = this.lsc.getBestInitialClassifiers();
        List<SimpleClassifier> result_classifiers = this.lsc.learnClassifer(init_classifiers);
        MLResults result = new MLResults();
        AMapping mapping = this.lsc.getMapping(result_classifiers);
        result.setMapping(mapping);
        result.setQuality(this.lsc.computeQuality(mapping));
        result.setLinkSpecification(this.lsc.getLinkSpecification(result_classifiers));
        result.setClassifiers(result_classifiers);
        for (int i = 0; i < result_classifiers.size(); ++i) {
            result.addDetail(i + ". Classifier ", result_classifiers.get(i));
            AMapping map = this.lsc.executeClassifier(result_classifiers.get(i), result_classifiers.get(i).getThreshold());
            result.addDetail(i + ". Mapping.size= ", map.size());
        }
        return result;
    }

    @Override
    protected MLResults learn(AMapping trainingData) throws UnsupportedMLImplementationException {
        this.configureEuclid(this.lsc);
        this.lsc.setPFMType(LinearSelfConfigurator.QMeasureType.SUPERVISED);
        this.lsc.setSupervisedBatch(trainingData);
        return this.learn();
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) throws UnsupportedMLImplementationException {
        this.configureEuclid(this.lsc);
        this.lsc.setPFMType(LinearSelfConfigurator.QMeasureType.UNSUPERVISED);
        return this.learn();
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        assert (mlModel.classifiersSet());
        List<SimpleClassifier> classifiers = mlModel.getClassifiers();
        assert (classifiers.size() > 0);
        LinearSelfConfigurator le = new LinearSelfConfigurator(source, target);
        this.configureEuclid(le);
        AMapping map = le.getMapping(classifiers);
        logger.info("Should predict with mlModel on Caches +" + source.size() + "," + target.size() + "+ resulted in " + map.size() + " map.");
        return map;
    }

    @Override
    protected boolean supports(MLImplementationType mlType) {
        return mlType.equals((Object)MLImplementationType.UNSUPERVISED) || mlType.equals((Object)MLImplementationType.SUPERVISED_BATCH);
    }

    @Override
    protected AMapping getNextExamples(int size) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Active Learning for Euclid is not implemented yet.");
    }

    @Override
    protected MLResults activeLearn(AMapping oracleMapping) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Active Learning for Euclid is not implemented yet.");
    }

    @Override
    protected MLResults activeLearn() throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Active Learning for Euclid is not implemented yet.");
    }

    protected void configureEuclid(LinearSelfConfigurator lsc) {
        boolean strict;
        if (lsc == null) {
            lsc = new LinearSelfConfigurator(this.sourceCache, this.targetCache);
        }
        double min_cov = (Double)this.getParameter(MIN_COVERAGE);
        lsc.beta = (Double)this.getParameter(BETA);
        if (Math.abs(lsc.min_coverage - min_cov) > 0.05) {
            lsc = new LinearSelfConfigurator(this.sourceCache, this.targetCache, lsc.beta, min_cov);
        }
        lsc.ITERATIONS_MAX = (Integer)this.getParameter(ITERATIONS_MAX);
        lsc.MIN_THRESHOLD = (Double)this.getParameter(MIN_THRESHOLD);
        lsc.kappa = (Double)this.getParameter(KAPPA);
        lsc.learningRate = (Double)this.getParameter(LEARNING_RATE);
        lsc.STRICT = strict = ((Boolean)this.getParameter(STRICT)).booleanValue();
    }
}

