/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionProblem;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringPreprocessMeasure
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = -4901752495126327127L;
    static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    private String operationName = "sim";
    private Set<String> allowedOperations = new HashSet<String>();
    private boolean m_mutateable;

    public StringPreprocessMeasure(String opName, GPConfiguration a_conf, Class<?> a_returnType, boolean a_mutateable) throws InvalidConfigurationException {
        super(a_conf, 4, a_returnType, 1, new int[]{ExpressionProblem.ResourceTerminalType.STRINGPROPPAIR.intValue(), ExpressionProblem.ResourceTerminalType.THRESHOLD.intValue(), ExpressionProblem.ResourceTerminalType.PREPROCESS.intValue(), ExpressionProblem.ResourceTerminalType.PREPROCESS.intValue()});
        this.fillOperationSet();
        this.setOperationName(opName);
        this.m_mutateable = a_mutateable;
        this.setNoValidation(false);
    }

    public String toString() {
        return this.operationName + "(&1)|&2";
    }

    public Class<?> getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return PairSimilar.class;
        }
        if (a_chromNum == 2 || a_chromNum == 3) {
            return String.class;
        }
        return CommandGene.DoubleClass;
    }

    public String getName() {
        return this.getOperationName();
    }

    public String getOperationName() {
        return this.operationName;
    }

    private void setOperationName(String opName) {
        this.operationName = opName;
        this.allowedOperations.add(opName);
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        PairSimilar propPair = (PairSimilar)a_chrom.execute_object(a_n, 0, args);
        double threshold = a_chrom.execute_double(a_n, 1, args);
        String preprocess1 = (String)a_chrom.execute_object(a_n, 2, args);
        String preprocess2 = (String)a_chrom.execute_object(a_n, 3, args);
        LinkSpecGeneticLearnerConfig ExpConfig = (LinkSpecGeneticLearnerConfig)this.getGPConfiguration();
        StringBuffer value = new StringBuffer(this.getOperationName());
        value.append("(");
        value.append(ExpConfig.getExpressionProperty("source", (String)propPair.a));
        value.append("[" + preprocess1 + "]");
        value.append(",");
        value.append(ExpConfig.getExpressionProperty("target", (String)propPair.b));
        value.append("[" + preprocess2 + "]");
        value.append(")");
        value.append("|");
        value.append(new BigDecimal(threshold).setScale(4, 6));
        return value.toString();
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    private void fillOperationSet() {
        this.allowedOperations.add("trigrams");
        this.allowedOperations.add("cosine");
        this.allowedOperations.add("jaccard");
        this.allowedOperations.add("levenshtein");
        this.allowedOperations.add("overlap");
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        if (!this.m_mutateable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    public CommandGene applyMutation() throws InvalidConfigurationException {
        String[] aO = new String[]{};
        aO = this.allowedOperations.toArray(aO);
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        String newOp = aO[randomGen.nextInt(aO.length)];
        StringPreprocessMeasure result = new StringPreprocessMeasure(newOp, this.getGPConfiguration(), this.getReturnType(), this.m_mutateable);
        return result;
    }

    public Object clone() {
        try {
            StringPreprocessMeasure result = new StringPreprocessMeasure(this.operationName, this.getGPConfiguration(), this.getReturnType(), this.m_mutateable);
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public boolean isValid(ProgramChromosome a_program, int a_index) {
        Object[] o = new Object[]{};
        LinkSpecGeneticLearnerConfig expConfig = (LinkSpecGeneticLearnerConfig)this.getGPConfiguration();
        PairSimilar propPair = (PairSimilar)a_program.execute_object(a_index, 0, o);
        return expConfig.getPropertyMapping().isMatch(propPair.a.toString(), propPair.b.toString());
    }

    public boolean isValid(ProgramChromosome a_program) {
        return this.isValid(a_program, 0);
    }
}

