/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.ICloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointSetPropertyPair
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = -5721724318558268858L;
    final Logger logger = LoggerFactory.getLogger((String)"LIMES");
    int pairIndex;
    PairSimilar<String> pair;
    boolean mutateable;
    LinkSpecGeneticLearnerConfig config;

    public PointSetPropertyPair(LinkSpecGeneticLearnerConfig a_conf, Class<?> a_returnType, int a_subReturnType, boolean a_mutateable, int propPairIndex) throws InvalidConfigurationException {
        super((GPConfiguration)a_conf, 0, a_returnType, a_subReturnType);
        this.mutateable = a_mutateable;
        this.config = a_conf;
        this.pairIndex = propPairIndex;
        this.pair = this.config.getPropertyMapping().pointsetPropPairs.get(this.pairIndex);
    }

    public PointSetPropertyPair(LinkSpecGeneticLearnerConfig a_conf, Class<?> a_returnType, int a_subReturnType, int propPairIndex) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_subReturnType, true, propPairIndex);
    }

    public String toString() {
        return (String)this.pair.a + "," + (String)this.pair.b;
    }

    public CommandGene applyMutation(int arg0, double arg1) throws InvalidConfigurationException {
        int randomAdd;
        if (!this.mutateable) {
            return this;
        }
        int maxIndex = this.config.getPropertyMapping().pointsetPropPairs.size() - 1;
        if (arg1 > 0.5 && this.pairIndex < maxIndex || this.pairIndex == 0) {
            RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
            randomAdd = randomGen.nextInt(Math.max(0, maxIndex - this.pairIndex + 1));
        } else {
            RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
            randomAdd = randomGen.nextInt(this.pairIndex + 1);
            randomAdd *= -1;
        }
        try {
            this.pair = this.config.getPropertyMapping().pointsetPropPairs.get(this.pairIndex + randomAdd);
            this.pairIndex += randomAdd;
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.warn("Failed to mutate (max=" + maxIndex + ") to PropertyPairIndex from " + this.pairIndex + " + " + randomAdd + " " + arg1);
        }
        return this;
    }

    public CommandGene clone() {
        try {
            PointSetPropertyPair newPair = new PointSetPropertyPair(this.config, this.getReturnType(), this.getSubReturnType(), this.mutateable, this.pairIndex);
            return newPair;
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
            return this;
        }
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        return this.pair;
    }
}

