/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import java.util.ArrayList;
import java.util.List;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class BooleanCommand
extends CommandGene
implements ICloneable,
IMutateable {
    private static final long serialVersionUID = 8309825108305749003L;
    private String metric = "AND";
    private List<String> supportedMetrics;
    private boolean m_mutateable = true;

    public BooleanCommand(GPConfiguration a_conf, String command) throws InvalidConfigurationException {
        this(a_conf, String.class, command);
    }

    public BooleanCommand(GPConfiguration a_conf, Class<?> a_returnType, String command) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType, 4, new int[]{1, 1});
        this.metric = command;
        this.supportedMetrics = new ArrayList<String>();
        this.supportedMetrics.add("AND");
        this.supportedMetrics.add("OR");
    }

    public Class<?> getChildType(IGPProgram a_ind, int a_chromNum) {
        return String.class;
    }

    public String toString() {
        return this.metric + "(sim1, sim2)";
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        StringBuffer value = new StringBuffer(this.metric);
        value.append("(");
        value.append(a_chrom.execute_object(a_n, 0, args));
        value.append(",");
        value.append(a_chrom.execute_object(a_n, 1, args));
        value.append(")");
        return value.toString();
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    public Object clone() {
        try {
            BooleanCommand result = new BooleanCommand(this.getGPConfiguration(), this.metric);
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        if (!this.m_mutateable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    private CommandGene applyMutation() {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        int index = randomGen.nextInt(this.supportedMetrics.size());
        this.metric = this.supportedMetrics.get(index);
        return this;
    }
}

