/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.core;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.ExecutionEngineFactory;
import org.aksw.limes.core.execution.planning.planner.ExecutionPlannerFactory;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.eagle.core.IGPFitnessFunction;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoFMeasureFitnessFunction
extends IGPFitnessFunction {
    private static final long serialVersionUID = -7114137172832439294L;
    static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    private static PseudoFMeasureFitnessFunction instance = null;
    public ExecutionEngine engine;
    ACache sourceCache;
    ACache targetCache;
    LinkSpecGeneticLearnerConfig config;
    double beta = 1.0;
    PseudoFMeasure pfm;

    private PseudoFMeasureFitnessFunction(LinkSpecGeneticLearnerConfig a_config, PseudoFMeasure pfm, ACache c1, ACache c2) {
        this.config = a_config;
        this.sourceCache = c1;
        this.targetCache = c2;
        this.pfm = pfm;
        this.engine = ExecutionEngineFactory.getEngine(ExecutionEngineFactory.ExecutionEngineType.DEFAULT, c1, c2, a_config.source.getVar(), a_config.target.getVar(), 0L, 1.0);
    }

    public static PseudoFMeasureFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, PseudoFMeasure pfm, ACache c1, ACache c2) {
        if (instance == null) {
            instance = new PseudoFMeasureFitnessFunction(a_config, pfm, c1, c2);
            return instance;
        }
        return instance;
    }

    protected double evaluate(IGPProgram program) {
        return this.calculateRawFitness(program);
    }

    @Override
    public double calculateRawFitness(IGPProgram p) {
        double pseudoFMeasure = this.calculatePseudoMeasure(p);
        if (!(pseudoFMeasure >= 0.0) || !(pseudoFMeasure <= 1.0)) {
            Object[] args = new Object[]{};
            ProgramChromosome pc = null;
            pc = p.getChromosome(0);
            LinkSpecification spec = (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
            logger.info("LS: " + spec);
            logger.error("Pseudo Measure was not in [0,1]");
            System.out.println("Pseudo Measure for (" + spec + ") was not in [0,1]");
            System.err.println("Pseudo Measure for (" + spec + ") was not in [0,1]");
        }
        if (pseudoFMeasure >= 0.0) {
            return Math.abs(1.0 - pseudoFMeasure);
        }
        return Math.abs(pseudoFMeasure) + 1.0;
    }

    public AMapping calculateMapping(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = null;
        pc = p.getChromosome(0);
        AMapping actualMapping = MappingFactory.createDefaultMapping();
        LinkSpecification spec = (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
        try {
            actualMapping = this.getMapping(this.sourceCache, this.targetCache, spec);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return MappingFactory.createDefaultMapping();
        }
        return actualMapping;
    }

    public Double calculatePseudoMeasure(IGPProgram p) {
        AMapping mapping = this.calculateMapping(p);
        GoldStandard gold = new GoldStandard(mapping, this.sourceCache, this.targetCache);
        return this.pfm.calculate(mapping, gold, this.beta);
    }

    @Override
    public AMapping getMapping(ACache sC, ACache tC, LinkSpecification spec) {
        try {
            Planner planner = ExecutionPlannerFactory.getPlanner(ExecutionPlannerFactory.ExecutionPlannerType.DEFAULT, sC, tC);
            return this.engine.execute(spec, planner);
        }
        catch (Exception e) {
            e.printStackTrace();
            String out = "Error getMapping() in PFM (" + this.config.source.getId() + " - " + this.config.target.getId() + ") with metric: " + spec + " \n" + e.getMessage();
            System.err.println(out);
            logger.error(out);
            return MappingFactory.createDefaultMapping();
        }
    }

    public void destroy() {
        instance = null;
    }

    public PseudoFMeasure getMeasure() {
        return this.pfm;
    }

    public void setMeasure(PseudoFMeasure pfm) {
        this.pfm = pfm;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Override
    public double calculateRawMeasure(IGPProgram p) {
        return this.calculatePseudoMeasure(p);
    }

    @Override
    public void addToReference(AMapping m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillCachesIncrementally(AMapping matches) {
        throw new UnsupportedOperationException();
    }
}

