/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions;

import java.util.ArrayList;
import java.util.Collections;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.execution.engine.filter.LinearFilter;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.classifier.ExtendedClassifier;
import org.aksw.limes.core.ml.algorithm.dragon.DecisionTree;
import org.aksw.limes.core.ml.algorithm.dragon.Dragon;
import org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions.FitnessFunctionDTL;

public class GlobalFMeasure
extends FitnessFunctionDTL {
    private ExtendedClassifier findClassifier(String sourceProperty, String targetProperty, String measure, DecisionTree currentNode) {
        String measureExpression = measure + "(x." + sourceProperty + ",y." + targetProperty + ")";
        ExtendedClassifier cp = new ExtendedClassifier(measure, 0.0, sourceProperty, targetProperty);
        if (currentNode.getParent() != null && currentNode.getParent().getPathString().contains(measureExpression)) {
            return null;
        }
        double maxFM = 0.0;
        double theta = 1.0;
        for (double threshold = 1.0; threshold > this.dt.getMinPropertyCoverage(); threshold *= this.dt.getPropertyLearningRate()) {
            cp = new ExtendedClassifier(measure, threshold, sourceProperty, targetProperty);
            AMapping mapping = currentNode.getMeasureMapping(measureExpression, cp);
            double pfm = this.calculateFMeasure(mapping, currentNode.getRefMapping(), currentNode);
            if (!(maxFM < pfm)) continue;
            theta = threshold;
            maxFM = pfm;
        }
        cp = new ExtendedClassifier(measure, theta, sourceProperty, targetProperty);
        cp.setfMeasure(maxFM);
        cp.setMapping(currentNode.executeAtomicMeasure(measureExpression, theta));
        return cp;
    }

    private AMapping removeNegativeExamplesFromMapping(AMapping m) {
        LinearFilter lf = new LinearFilter();
        return lf.filter(m, 1.0);
    }

    private double calculateFMeasure(AMapping mapping, AMapping refMap, DecisionTree currentNode) {
        AMapping updatedRefMapping = this.removeNegativeExamplesFromMapping(refMap);
        double res = 0.0;
        GoldStandard gs = new GoldStandard(updatedRefMapping, currentNode.getSourceCache().getAllUris(), currentNode.getTargetCache().getAllUris());
        FMeasure fm = new FMeasure();
        res = fm.calculate(mapping, gs);
        return res;
    }

    @Override
    public ExtendedClassifier getBestClassifier(DecisionTree currentNode) {
        ArrayList<ExtendedClassifier> initialClassifiers = new ArrayList<ExtendedClassifier>();
        for (PairSimilar<String> propPair : this.propertyMapping.stringPropPairs) {
            for (String measure : Dragon.defaultMeasures) {
                ExtendedClassifier cp = this.findClassifier((String)propPair.a, (String)propPair.b, measure, currentNode);
                if (cp == null) continue;
                initialClassifiers.add(cp);
            }
        }
        Collections.sort(initialClassifiers, Collections.reverseOrder());
        if (initialClassifiers.size() == 0 || ((ExtendedClassifier)initialClassifiers.get(0)).getfMeasure() == 0.0) {
            return null;
        }
        return (ExtendedClassifier)initialClassifiers.get(0);
    }

    @Override
    public boolean stopCondition(DecisionTree currentNode) {
        return currentNode.getClassifier() != null && currentNode.getClassifier().getfMeasure() == 1.0;
    }
}

