/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.NoSuchParameterException;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ACoreMLAlgorithm {
    protected static Logger logger = LoggerFactory.getLogger(ACoreMLAlgorithm.class);
    protected List<LearningParameter> learningParameters = new ArrayList<LearningParameter>();
    protected ACache sourceCache;
    protected ACache targetCache;
    protected Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected abstract String getName();

    protected List<LearningParameter> getParameters() {
        return this.learningParameters;
    }

    public abstract void setDefaultParameters();

    protected void init(List<LearningParameter> learningParameters, ACache sourceCache, ACache targetCache) {
        if (learningParameters != null) {
            for (LearningParameter lp : learningParameters) {
                this.setParameter(lp.getName(), lp.getValue());
            }
        }
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
    }

    protected abstract MLResults learn(AMapping var1) throws UnsupportedMLImplementationException;

    protected abstract MLResults learn(PseudoFMeasure var1) throws UnsupportedMLImplementationException;

    protected abstract AMapping predict(ACache var1, ACache var2, MLResults var3);

    protected abstract boolean supports(MLImplementationType var1);

    protected abstract AMapping getNextExamples(int var1) throws UnsupportedMLImplementationException;

    protected abstract MLResults activeLearn(AMapping var1) throws UnsupportedMLImplementationException;

    protected abstract MLResults activeLearn() throws UnsupportedMLImplementationException;

    protected Object getParameter(String name) {
        for (LearningParameter par : this.learningParameters) {
            if (!par.getName().equals(name)) continue;
            return par.getValue();
        }
        return new NoSuchParameterException(name);
    }

    public void setParameter(String par, Object val) {
        for (LearningParameter lp : this.learningParameters) {
            if (!lp.getName().equals(par)) continue;
            lp.setValue(val);
            return;
        }
        throw new NoSuchParameterException(par);
    }

    public ACache getSourceCache() {
        return this.sourceCache;
    }

    public ACache getTargetCache() {
        return this.targetCache;
    }
}

