/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.mapper.string.fastngram.ITokenizer;
import org.aksw.limes.core.measures.mapper.string.fastngram.NGramTokenizer;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class QGramSimilarityMeasure
extends StringMeasure {
    ITokenizer tokenizer = new NGramTokenizer();
    int q = 3;

    public QGramSimilarityMeasure(int q) {
    }

    public QGramSimilarityMeasure() {
    }

    public double getSimilarity(String x, String y) {
        Set<String> yTokens = this.tokenizer.tokenize(y, this.q);
        Set<String> xTokens = this.tokenizer.tokenize(x, this.q);
        return this.getSimilarity(xTokens, yTokens);
    }

    public double getSimilarity(Set<String> X, Set<String> Y) {
        double x = X.size();
        double y = Y.size();
        HashSet<String> K = new HashSet<String>();
        for (String s : X) {
            K.add(s);
        }
        K.retainAll(Y);
        double z = K.size();
        return z / (x + y - z);
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.getSimilarity(source, target);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "qgrams";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

