/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.LinkedList;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.ITrieFilterableStringMeasure;
import org.aksw.limes.core.measures.measure.string.StringMeasure;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class JaroWinklerMeasure
extends StringMeasure
implements ITrieFilterableStringMeasure {
    public static double winklerBoostThreshold = 0.7;
    private static char[][] sp = new char[][]{{'A', 'E'}, {'A', 'I'}, {'A', 'O'}, {'A', 'U'}, {'B', 'V'}, {'E', 'I'}, {'E', 'O'}, {'E', 'U'}, {'I', 'O'}, {'I', 'U'}, {'O', 'U'}, {'I', 'Y'}, {'E', 'Y'}, {'C', 'G'}, {'E', 'F'}, {'W', 'U'}, {'W', 'V'}, {'X', 'K'}, {'S', 'Z'}, {'X', 'S'}, {'Q', 'C'}, {'U', 'V'}, {'M', 'N'}, {'L', 'I'}, {'Q', 'O'}, {'P', 'R'}, {'I', 'J'}, {'2', 'Z'}, {'5', 'S'}, {'8', 'B'}, {'1', 'I'}, {'1', 'L'}, {'0', 'O'}, {'0', 'Q'}, {'C', 'K'}, {'G', 'J'}, {'E', ' '}, {'Y', ' '}, {'S', ' '}};
    private int[][] adjwt;
    private boolean simOn;
    private boolean uppercase;
    private boolean longStrings;

    public JaroWinklerMeasure() {
        this(true, false, false);
    }

    public JaroWinklerMeasure(boolean uppercaseOn, boolean longStringsOn, boolean characterSimilarityOn) {
        this.uppercase = uppercaseOn;
        this.longStrings = longStringsOn;
        this.simOn = characterSimilarityOn;
        if (characterSimilarityOn) {
            int i;
            this.adjwt = new int[91][91];
            for (i = 0; i < 91; ++i) {
                for (int j = 0; j < 91; ++j) {
                    this.adjwt[i][j] = 0;
                }
            }
            for (i = 0; i < 36; ++i) {
                this.adjwt[JaroWinklerMeasure.sp[i][0]][JaroWinklerMeasure.sp[i][1]] = 3;
                this.adjwt[JaroWinklerMeasure.sp[i][1]][JaroWinklerMeasure.sp[i][0]] = 3;
            }
        }
    }

    private boolean notNum(char c) {
        return c > '9' || c < '0';
    }

    private boolean inRange(char c) {
        return c > '\u0000' && c < '[';
    }

    public JaroWinklerMeasure clone() {
        return new JaroWinklerMeasure(this.uppercase, this.longStrings, this.simOn);
    }

    public double proximity(char[] yin, char[] yang) {
        double sim;
        int j;
        int i;
        boolean[] yinFlags = new boolean[yin.length];
        boolean[] yangFlags = new boolean[yang.length];
        for (i = 0; i < yin.length; ++i) {
            yinFlags[i] = false;
        }
        for (i = 0; i < yang.length; ++i) {
            yangFlags[i] = false;
        }
        boolean matriarch = yin.length > yang.length;
        int len = matriarch ? yang.length : yin.length;
        int range = matriarch ? yin.length : yang.length;
        if ((range = range / 2 - 1) < 0) {
            range = 0;
        }
        int k = 0;
        int t = 0;
        int m = 0;
        block2: for (i = 0; i < yin.length; ++i) {
            int low = i >= range ? i - range : 0;
            int high = i + range + 1 <= yang.length ? i + range : yang.length - 1;
            for (j = low; j <= high; ++j) {
                if (yangFlags[j] || yang[j] != yin[i]) continue;
                yangFlags[j] = true;
                yinFlags[i] = true;
                ++m;
                continue block2;
            }
        }
        if (m == 0) {
            return 0.0;
        }
        for (i = 0; i < yin.length; ++i) {
            if (!yinFlags[i]) continue;
            for (j = k; j < yang.length; ++j) {
                if (!yangFlags[j]) continue;
                k = j + 1;
                break;
            }
            if (yin[i] == yang[j]) continue;
            ++t;
        }
        t /= 2;
        if (len > m && this.simOn) {
            sim = 0.0;
            block6: for (i = 0; i < yin.length; ++i) {
                if (yinFlags[i] || !this.inRange(yin[i])) continue;
                for (j = 0; j < yang.length; ++j) {
                    if (yangFlags[j] || !this.inRange(yang[j]) || this.adjwt[yin[i]][yang[j]] <= 0) continue;
                    sim += (double)this.adjwt[yin[i]][yang[j]];
                    yangFlags[j] = true;
                    continue block6;
                }
            }
            sim = sim / 10.0 + (double)m;
        } else {
            sim = m;
        }
        double weight = sim / (double)yin.length + sim / (double)yang.length + (double)(m - t) / (double)m;
        weight /= 3.0;
        if (weight > winklerBoostThreshold) {
            k = len >= 4 ? 4 : len;
            for (i = 0; i < k && yin[i] == yang[i] && this.notNum(yin[i]); ++i) {
            }
            if (i > 0) {
                weight += (double)i * 0.1 * (1.0 - weight);
            }
            if (this.longStrings && len > 4 && m > i + 1 && 2 * m >= len + i && this.notNum(yin[0])) {
                weight += (1.0 - weight) * (double)(m - i - 1) / ((double)(yin.length + yang.length) - (double)i * 2.0 + 2.0);
            }
        }
        return weight;
    }

    @Override
    public double proximity(String yi, String ya) {
        return this.proximity(this.getArrayRepresentation(yi), this.getArrayRepresentation(ya));
    }

    public char[] getArrayRepresentation(String s) {
        s = s.trim();
        if (this.uppercase) {
            s = s.toUpperCase();
        }
        return s.toCharArray();
    }

    @Override
    public double characterFrequencyUpperBound(int l1, int l2, int m) {
        double theta = ((double)m / (double)l1 + (double)m / (double)l2 + 1.0) / 3.0;
        if (theta > winklerBoostThreshold) {
            theta += 0.4 * (1.0 - theta);
        }
        return theta;
    }

    @Override
    public int characterMatchLowerBound(int l1, int l2, double threshold) {
        return (int)Math.round(Math.ceil((threshold - 0.6) * (3.0 * (double)l2 * (double)l1 / (0.6 * ((double)l2 + (double)l1)))));
    }

    @Override
    public int lengthUpperBound(int l1, double threshold) {
        if (threshold <= 0.8) {
            return -1;
        }
        return (int)Math.round(Math.ceil(0.6 * (double)l1 / (3.0 * threshold - 2.4)));
    }

    @Override
    public int lengthLowerBound(int l1, double threshold) {
        return (int)Math.round(Math.floor((double)l1 * (3.0 * threshold - 2.4) / 0.6));
    }

    @Override
    public LinkedList<ImmutableTriple<Integer, Integer, Integer>> getPartitionBounds(int maxSize, double threshold) {
        LinkedList<ImmutableTriple<Integer, Integer, Integer>> sliceBoundaries = new LinkedList<ImmutableTriple<Integer, Integer, Integer>>();
        for (int t = 1; t <= maxSize; ++t) {
            sliceBoundaries.add((ImmutableTriple<Integer, Integer, Integer>)new ImmutableTriple((Object)t, (Object)this.lengthLowerBound(t, threshold), (Object)this.lengthUpperBound(t, threshold)));
        }
        return sliceBoundaries;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        return false;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return this.proximity(object1.toString(), object2.toString());
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            char[] cSource = this.getArrayRepresentation(source);
            for (String target : instance2.getProperty(property2)) {
                char[] cTarget = this.getArrayRepresentation(target);
                sim = this.proximity(cSource, cTarget);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "jaro-winkler";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

