/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.finders;

import edu.mit.jwi.item.ISynsetID;
import java.util.ArrayList;
import java.util.List;

public class LeastCommonSubsumerFinder {
    LeastCommonSubsumer lcs = null;

    public int getDepth() {
        if (this.lcs == null) {
            return -1;
        }
        return this.lcs.getDepth();
    }

    public int getSynsetsDistance() {
        if (this.lcs == null) {
            return -1;
        }
        return this.lcs.getSynsetsDistance();
    }

    public void getLeastCommonSubsumer(ArrayList<ArrayList<ISynsetID>> synset1Tree, ArrayList<ArrayList<ISynsetID>> synset2Tree) {
        if (synset1Tree == null || synset2Tree == null) {
            return;
        }
        if (synset1Tree.isEmpty() || synset2Tree.isEmpty()) {
            return;
        }
        this.lcs = new LeastCommonSubsumer();
        for (List list : synset1Tree) {
            for (List list2 : synset2Tree) {
                int path2Pos;
                int path1Pos = 0;
                for (path2Pos = 0; path1Pos < list.size() && path2Pos < list2.size() && ((ISynsetID)list.get(path1Pos)).getOffset() == ((ISynsetID)list2.get(path2Pos)).getOffset(); ++path1Pos, ++path2Pos) {
                }
                int newPath = list.size() + list2.size() - 2 * path1Pos;
                int oldPath = this.lcs.getPs1().size() + this.lcs.getPs2().size();
                if (this.lcs.getPath() != null && path1Pos <= this.lcs.getDepth() && (path1Pos != this.lcs.getDepth() || newPath >= oldPath)) continue;
                this.lcs.setPaths(list.subList(0, path1Pos), list.subList(path1Pos, list.size()), list2.subList(path2Pos, list2.size()));
            }
        }
    }

    private class LeastCommonSubsumer {
        protected List<ISynsetID> ps1 = new ArrayList<ISynsetID>();
        protected List<ISynsetID> ps2 = new ArrayList<ISynsetID>();
        protected List<ISynsetID> path;

        protected LeastCommonSubsumer() {
        }

        protected void setPaths(List<ISynsetID> p, List<ISynsetID> pathSynset1, List<ISynsetID> pathSynset2) {
            this.ps1 = pathSynset1;
            this.ps2 = pathSynset2;
            this.path = p;
        }

        protected List<ISynsetID> getPs1() {
            return this.ps1;
        }

        protected List<ISynsetID> getPs2() {
            return this.ps2;
        }

        protected int getDepth() {
            if (this.path != null) {
                return this.path.size();
            }
            return 0;
        }

        protected int getSynsetsDistance() {
            return this.ps1.size() + this.ps2.size();
        }

        protected List<ISynsetID> getPath() {
            return this.path;
        }
    }
}

