/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.finders;

import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.Pointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.dictionary.SemanticDictionary;

public class HypernymPathsFinder {
    public static boolean useInstanceHypernyms = true;
    public static boolean useHypernyms = true;

    public static ArrayList<ArrayList<ISynsetID>> getHypernymPaths(SemanticDictionary dictionary, ISynset synset) {
        if (synset == null) {
            return new ArrayList<ArrayList<ISynsetID>>();
        }
        ArrayList<ArrayList<ISynsetID>> trees = HypernymPathsFinder.getHypernymPaths(dictionary, synset, new HashSet<ISynsetID>());
        return trees;
    }

    public static ArrayList<ArrayList<ISynsetID>> getHypernymPaths(SemanticDictionary dictionary, ISynset synset, Set<ISynsetID> history) {
        useInstanceHypernyms = synset.getType() == 1;
        useHypernyms = synset.getType() == 1 || synset.getType() == 2;
        List hypernymIds = useHypernyms ? synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM) : Collections.emptyList();
        List instanceHypernymIds = useInstanceHypernyms ? synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE) : Collections.emptyList();
        ArrayList<ArrayList<ISynsetID>> result = new ArrayList<ArrayList<ISynsetID>>();
        if (hypernymIds.size() == 0 && instanceHypernymIds.size() == 0) {
            ArrayList<ISynsetID> tree = new ArrayList<ISynsetID>();
            tree.add((ISynsetID)synset.getID());
            result.add(tree);
        } else {
            ArrayList<ArrayList<ISynsetID>> hypernymTrees;
            for (ISynsetID hypernymId : hypernymIds) {
                hypernymTrees = HypernymPathsFinder.getHypernymPaths(dictionary, dictionary.getSynset(hypernymId), history);
                for (ArrayList<ISynsetID> hypernymTree : hypernymTrees) {
                    hypernymTree.add((ISynsetID)synset.getID());
                    result.add(hypernymTree);
                }
            }
            for (ISynsetID hypernymId : instanceHypernymIds) {
                hypernymTrees = HypernymPathsFinder.getHypernymPaths(dictionary, dictionary.getSynset(hypernymId), history);
                for (ArrayList<ISynsetID> hypernymTree : hypernymTrees) {
                    hypernymTree.add((ISynsetID)synset.getID());
                    result.add(hypernymTree);
                }
            }
        }
        return result;
    }
}

