/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.AMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.IEdgeCountingSemanticMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.dictionary.SemanticDictionary;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Stopwords;
import weka.core.tokenizers.Tokenizer;
import weka.core.tokenizers.WordTokenizer;

public abstract class AEdgeCountingSemanticMeasure
extends AMeasure
implements IEdgeCountingSemanticMeasure {
    private static final Logger logger = LoggerFactory.getLogger(AEdgeCountingSemanticMeasure.class);
    protected static final int NOUN_DEPTH = 19;
    protected static final int VERB_DEPTH = 13;
    protected static final int ADJECTIVE_DEPTH = 1;
    protected static final int ADVERB_DEPTH = 1;
    protected AIndex Indexer = null;
    protected SemanticDictionary dictionary = new SemanticDictionary();

    public AEdgeCountingSemanticMeasure(AIndex indexer) {
        this.dictionary.exportDictionaryToFile();
        this.dictionary.openDictionaryFromFile();
        this.Indexer = indexer;
    }

    public SemanticDictionary getSemanticDictionary() {
        return this.dictionary;
    }

    public void setDictionary(SemanticDictionary dict) {
        this.dictionary = dict;
    }

    public int getHierarchyDepth(int posNumber) {
        if (posNumber == 1) {
            return 19;
        }
        if (posNumber == 2) {
            return 13;
        }
        if (posNumber == 4) {
            return 1;
        }
        if (posNumber == 5 || posNumber == 3) {
            return 1;
        }
        logger.error("Unknown POS. Exiting");
        throw new RuntimeException();
    }

    public IWord getIWord(IWordID wordID) {
        IWord iword = null;
        if (wordID != null) {
            iword = this.dictionary.getWord(wordID);
        }
        return iword;
    }

    public ISynset getSynset(IWord iword) {
        if (iword == null) {
            return null;
        }
        return iword.getSynset();
    }

    public List<IWordID> getWordIDs(IIndexWord w) {
        List wordIDs = w.getWordIDs();
        return wordIDs;
    }

    public ArrayList<ArrayList<ISynsetID>> getPaths(ISynset synset) {
        if (synset == null) {
            return new ArrayList<ArrayList<ISynsetID>>();
        }
        ArrayList<ArrayList<ISynsetID>> paths = this.Indexer.getHypernymPaths(synset);
        return paths;
    }

    public double getSimilarity(ISynset synset1, ISynset synset2) {
        double sim = 0.0;
        sim = this.getSimilarityBetweenConcepts(synset1, synset2);
        return sim;
    }

    public double getSimilarity(IIndexWord w1, IIndexWord w2) {
        double sim = 0.0;
        double maxSim = 0.0;
        if (w1 == null || w2 == null) {
            return maxSim;
        }
        if (w1.getPOS().getNumber() != w2.getPOS().getNumber()) {
            return maxSim;
        }
        List<IWordID> wordIDs1 = this.getWordIDs(w1);
        if (wordIDs1 == null) {
            return maxSim;
        }
        List<IWordID> wordIDs2 = this.getWordIDs(w2);
        if (wordIDs2 == null) {
            return maxSim;
        }
        for (IWordID wordID1 : wordIDs1) {
            ISynset synset1;
            IWord iword1 = this.getIWord(wordID1);
            if (iword1 == null || (synset1 = this.getSynset(iword1)) == null) continue;
            for (IWordID wordID2 : wordIDs2) {
                ISynset synset2;
                IWord iword2 = this.getIWord(wordID2);
                if (iword2 == null || (synset2 = this.getSynset(iword2)) == null) continue;
                sim = this.getSimilarity(synset1, synset2);
                if (sim > maxSim) {
                    maxSim = sim;
                }
                if (maxSim != 1.0) continue;
                return maxSim;
            }
        }
        return maxSim;
    }

    public String[] tokenize(String[] strings) {
        String[] tokens = null;
        try {
            tokens = Tokenizer.tokenize((Tokenizer)new WordTokenizer(), (String[])strings);
        }
        catch (Exception e) {
            logger.error("Couldn't tokenize: " + strings[0]);
            e.printStackTrace();
        }
        return tokens;
    }

    public double checkSimilarity(HashMap<String, Double> similaritiesMap, String sourceToken, String targetToken) {
        double similarity = 0.0;
        String together = sourceToken + "||" + targetToken;
        String together2 = targetToken + "||" + sourceToken;
        similarity = similaritiesMap.containsKey(together) ? similaritiesMap.get(together) : (similaritiesMap.containsKey(together2) ? similaritiesMap.get(together2) : Double.MAX_VALUE);
        return similarity;
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double sim = 0.0;
        double maxSim = 0.0;
        ArrayList<String[]> targetInTokens = new ArrayList<String[]>();
        for (String targetValue : instance2.getProperty(property2)) {
            if (targetValue.equals("")) continue;
            String[] tempTokens = this.tokenize(new String[]{targetValue});
            targetInTokens.add(tempTokens);
        }
        HashMap<String, Double> similaritiesMap = new HashMap<String, Double>();
        block1: for (String sourceValue : instance1.getProperty(property1)) {
            if (sourceValue.equals("")) continue;
            String[] sourceTokens = this.tokenize(new String[]{sourceValue});
            for (String[] targetTokens : targetInTokens) {
                double sourceTokensSum = 0.0;
                int nonSWCounter = 0;
                for (String sourceToken : sourceTokens) {
                    boolean flagSource = Stopwords.isStopword((String)sourceToken);
                    if (flagSource) continue;
                    ++nonSWCounter;
                    double maxTargetTokenSim = 0.0;
                    for (String targetToken : targetTokens) {
                        boolean flagTarget = Stopwords.isStopword((String)targetToken);
                        if (flagTarget) continue;
                        double targetTokenSim = 0.0;
                        double tempSim = this.checkSimilarity(similaritiesMap, sourceToken, targetToken);
                        if (tempSim == Double.MAX_VALUE) {
                            targetTokenSim = sourceToken.equals(targetToken) ? 1.0 : this.getSimilarity(sourceToken, targetToken);
                            similaritiesMap.put(sourceToken + "||" + targetToken, targetTokenSim);
                        } else {
                            targetTokenSim = tempSim;
                        }
                        if (targetTokenSim > maxTargetTokenSim) {
                            maxTargetTokenSim = targetTokenSim;
                        }
                        if (maxTargetTokenSim == 1.0) break;
                    }
                    sourceTokensSum += maxTargetTokenSim;
                }
                sim = nonSWCounter > 0 ? sourceTokensSum / (double)nonSWCounter : 0.0;
                if (sim > maxSim) {
                    maxSim = sim;
                }
                if (maxSim != 1.0) continue;
                continue block1;
            }
        }
        return maxSim;
    }

    public void close() {
        this.dictionary.removeDictionary();
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return 0.0;
        }
        IIndexWord idxWord1 = this.getIIndexWord(object1.toString());
        IIndexWord idxWord2 = this.getIIndexWord(object2.toString());
        if (idxWord1 == null || idxWord2 == null) {
            return 0.0;
        }
        if (idxWord1.getPOS().getNumber() != idxWord2.getPOS().getNumber()) {
            return 0.0;
        }
        return this.getSimilarity(idxWord1, idxWord2);
    }

    public IIndexWord getIIndexWord(String str) {
        if (str == null) {
            return null;
        }
        IIndexWord idxWord1 = this.dictionary.getIndexWord(str, POS.NOUN);
        if (idxWord1 == null && (idxWord1 = this.dictionary.getIndexWord(str, POS.ADJECTIVE)) == null && (idxWord1 = this.dictionary.getIndexWord(str, POS.ADVERB)) == null) {
            idxWord1 = this.dictionary.getIndexWord(str, POS.VERB);
        }
        return idxWord1;
    }
}

