/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.surjection;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;

public class SurjectionFinder {
    protected List<PairSimilar<Point>> surjectionPairsList = new ArrayList<PairSimilar<Point>>();
    protected Polygon small;
    protected Polygon large;

    SurjectionFinder(Polygon X, Polygon Y) {
        if (X.points.size() < Y.points.size()) {
            this.small = X;
            this.large = Y;
        } else {
            this.small = Y;
            this.large = X;
        }
    }

    public List<PairSimilar<Point>> getSurjectionPairsList() {
        if (this.surjectionPairsList.isEmpty()) {
            Polygon largeCopy = new Polygon(this.large);
            for (Point s : this.small.points) {
                Point l = this.getNearestPoint(s, largeCopy);
                this.surjectionPairsList.add(new PairSimilar<Point>(l, s));
                largeCopy.remove(l);
            }
            for (Point l : largeCopy.points) {
                Point s = this.getNearestPoint(l, this.small);
                this.surjectionPairsList.add(new PairSimilar<Point>(l, s));
            }
        }
        return this.surjectionPairsList;
    }

    protected Point getNearestPoint(Point x, Polygon Y) {
        double min = Double.MAX_VALUE;
        Point result = null;
        for (Point y : Y.points) {
            double d = APointsetsMeasure.pointToPointDistance(x, y);
            if (!(d < min)) continue;
            min = d;
            result = y;
        }
        return result;
    }

    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

