/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.surjection;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.surjection.SurjectionFinder;

public class FairSurjectionFinder
extends SurjectionFinder {
    FairSurjectionFinder(Polygon X, Polygon Y) {
        super(X, Y);
    }

    public List<PairSimilar<Point>> getFairSurjectionPairsList() {
        if (this.surjectionPairsList.isEmpty()) {
            int fairCapacity = (int)Math.ceil((double)this.large.points.size() / (double)this.small.points.size());
            block0: for (Point s : this.small.points) {
                int fairCount = 0;
                TreeMap<Double, Point> nearestPoints = this.getSortedNearestPoints(s, this.large);
                for (Map.Entry<Double, Point> e : nearestPoints.entrySet()) {
                    Point l = e.getValue();
                    this.surjectionPairsList.add(new PairSimilar<Point>(l, s));
                    if (++fairCount != fairCapacity) continue;
                    continue block0;
                }
            }
        }
        return this.surjectionPairsList;
    }

    TreeMap<Double, Point> getSortedNearestPoints(Point x, Polygon Y) {
        TreeMap<Double, Point> result = new TreeMap<Double, Point>();
        for (Point y : Y.points) {
            result.put(APointsetsMeasure.pointToPointDistance(x, y), y);
        }
        return result;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

