/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.sumofmin;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.min.NaiveMinMeasure;

public class NaiveSumOfMinMeasure
extends APointsetsMeasure {
    public NaiveSumOfMinMeasure() {
        computations = 0;
    }

    public static double distance(Polygon X, Polygon Y, double threshold) {
        NaiveMinMeasure m = new NaiveMinMeasure();
        return (m.computeDistance(X, Y, threshold) + m.computeDistance(Y, X, threshold)) / 2.0;
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        return (this.SumOfMins(X, Y) + this.SumOfMins(Y, X)) / 2.0;
    }

    private double SumOfMins(Polygon X, Polygon Y) {
        double sum = 0.0;
        for (Point x : X.points) {
            sum += this.computeMinDistance(x, Y);
        }
        return sum;
    }

    private double computeMinDistance(Point x, Polygon Y) {
        double min = Double.MAX_VALUE;
        for (Point y : Y.points) {
            double d = NaiveSumOfMinMeasure.pointToPointDistance(x, y);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    @Override
    public String getName() {
        return "naiveSumOfMin";
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = this.computeDistance(s, t, threshold);
                if (!(d <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    @Override
    public String getType() {
        return "geodistance";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        TreeSet<String> source = instance1.getProperty(property1);
        TreeSet<String> target = instance2.getProperty(property2);
        HashSet<Polygon> sourcePolygons = new HashSet<Polygon>();
        HashSet<Polygon> targetPolygons = new HashSet<Polygon>();
        for (String s : source) {
            sourcePolygons.add(OrchidMapper.getPolygon(s));
        }
        for (String t : target) {
            targetPolygons.add(OrchidMapper.getPolygon(t));
        }
        double min = Double.MAX_VALUE;
        double d = 0.0;
        for (Polygon p1 : sourcePolygons) {
            for (Polygon p2 : targetPolygons) {
                d = this.computeDistance(p1, p2, 0.0);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return 1.0 / (1.0 + d);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

