/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.hausdorff;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PolygonIndex;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.NaiveHausdorffMeasure;

public class IndexedHausdorffMeasure
extends APointsetsMeasure {
    public PolygonIndex targetIndex = null;
    public NaiveHausdorffMeasure nh;

    public IndexedHausdorffMeasure() {
        computations = 0;
        this.nh = new NaiveHausdorffMeasure();
    }

    @Override
    public int getComputations() {
        return computations + this.targetIndex.computations;
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        this.targetIndex = new PolygonIndex();
        this.targetIndex.index(target);
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = this.computeDistance(s, t, threshold);
                if (!(d <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    public Map<Point, Map<Point, Double>> getInnerDistances(Polygon s) {
        HashMap<Point, Map<Point, Double>> distances = new HashMap<Point, Map<Point, Double>>();
        for (int i = 0; i < s.points.size(); ++i) {
            HashMap<Point, Double> buffer = new HashMap<Point, Double>();
            for (int j = i + 1; j < s.points.size(); ++j) {
                buffer.put(s.points.get(j), IndexedHausdorffMeasure.pointToPointDistance(s.points.get(i), s.points.get(j)));
            }
            distances.put(s.points.get(i), buffer);
        }
        return distances;
    }

    public Map<String, Map<String, Double>> runWithoutIndex(Set<Polygon> source, Set<Polygon> target, double threshold) {
        HashMap<String, Map<String, Double>> map = new HashMap<String, Map<String, Double>>();
        for (Polygon s : source) {
            Map<Point, Map<Point, Double>> distances = this.getInnerDistances(s);
            HashMap<String, Double> mapping = new HashMap<String, Double>();
            for (Polygon t : target) {
                double max = 0.0;
                HashMap exemplars = new HashMap();
                for (Point x : s.points) {
                    double d;
                    double min;
                    if (exemplars.isEmpty()) {
                        min = Double.POSITIVE_INFINITY;
                        for (Point y : t.points) {
                            d = IndexedHausdorffMeasure.pointToPointDistance(x, y);
                            if (!exemplars.containsKey(x)) {
                                exemplars.put(x, new HashMap());
                            }
                            ((Map)exemplars.get(x)).put(y, d);
                            if (!(d < min)) continue;
                            min = d;
                        }
                    } else {
                        min = Double.POSITIVE_INFINITY;
                        for (Point y : t.points) {
                            boolean approximationWorked = false;
                            for (Point e : exemplars.keySet()) {
                                double approximation = 0.0;
                                if (((Map)exemplars.get(e)).containsKey(y)) {
                                    approximation = s.points.indexOf(x) < s.points.indexOf(e) ? Math.abs(distances.get(x).get(e) - (Double)((Map)exemplars.get(e)).get(y)) : Math.abs(distances.get(e).get(x) - (Double)((Map)exemplars.get(e)).get(y));
                                }
                                if (!(approximation > threshold)) continue;
                                approximationWorked = true;
                                break;
                            }
                            if (approximationWorked) continue;
                            d = IndexedHausdorffMeasure.pointToPointDistance(x, y);
                            if (!exemplars.containsKey(x)) {
                                exemplars.put(x, new HashMap());
                            }
                            ((Map)exemplars.get(x)).put(y, d);
                            if (!(min > d)) continue;
                            min = d;
                        }
                    }
                    if (max < min) {
                        max = min;
                    }
                    if (!(max > threshold)) continue;
                    break;
                }
                if (!(max <= threshold)) continue;
                mapping.put(t.uri, max);
            }
            if (mapping.isEmpty()) continue;
            map.put(s.uri, mapping);
        }
        return map;
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        if (X.uri.equals(Y.uri)) {
            return 0.0;
        }
        double max = 0.0;
        double min = 0.0;
        for (Point x : X.points) {
            HashMap<Point, Double> distances = new HashMap<Point, Double>();
            for (Point y : Y.points) {
                double d;
                if (distances.isEmpty()) {
                    min = IndexedHausdorffMeasure.pointToPointDistance(x, y);
                    distances.put(y, min);
                    continue;
                }
                double minDist = Double.POSITIVE_INFINITY;
                Point exemplar = null;
                for (Point e : distances.keySet()) {
                    double dist = this.targetIndex.getDistance(Y.uri, e, y);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    exemplar = e;
                }
                double approx = Math.abs((Double)distances.get(exemplar) - minDist);
                if (approx > threshold) {
                    d = threshold + 1.0;
                    if (!(min > d)) continue;
                    min = d;
                    continue;
                }
                if (!(approx < min)) continue;
                d = IndexedHausdorffMeasure.pointToPointDistance(x, y);
                distances.put(y, d);
                if (!(min > d)) continue;
                min = d;
            }
            if (max < min) {
                max = min;
            }
            if (!(max > threshold)) continue;
            return max;
        }
        return max;
    }

    @Override
    public String getName() {
        return "indexedHausdorff";
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return this.nh.getSimilarity(object1, object2);
    }

    @Override
    public String getType() {
        return this.nh.getType();
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        return this.nh.getSimilarity(instance1, instance2, property1, property2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

