/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.hausdorff;

import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.NaiveHausdorffMeasure;

public class FastHausdorffMeasure
extends NaiveHausdorffMeasure {
    public FastHausdorffMeasure() {
        this.computations = 0;
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        double max = 0.0;
        for (Point x : X.points) {
            double min = Double.POSITIVE_INFINITY;
            for (Point y : Y.points) {
                double d = FastHausdorffMeasure.pointToPointDistance(x, y);
                if (!(min > d)) continue;
                min = d;
            }
            if (min > threshold) {
                return min;
            }
            if (!(max < min)) continue;
            max = min;
        }
        return max;
    }

    @Override
    public String getName() {
        return "fast";
    }
}

