/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.util.LimesWktReader;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RADON {
    public static final String EQUALS = "equals";
    public static final String DISJOINT = "disjoint";
    public static final String INTERSECTS = "intersects";
    public static final String TOUCHES = "touches";
    public static final String CROSSES = "crosses";
    public static final String WITHIN = "within";
    public static final String CONTAINS = "contains";
    public static final String OVERLAPS = "overlaps";
    public static final String COVERS = "covers";
    public static final String COVEREDBY = "coveredby";
    public static String heuristicStatMeasure = "avg";
    private static final Logger logger = LoggerFactory.getLogger(RADON.class);

    public static Map<String, Geometry> getGeometryMapFromCache(ACache c, String property) {
        LimesWktReader wktReader = new LimesWktReader();
        HashMap<String, Geometry> gMap = new HashMap<String, Geometry>();
        for (String uri : c.getAllUris()) {
            TreeSet<String> values = c.getInstance(uri).getProperty(property);
            if (values.size() <= 0) continue;
            String wkt = (String)values.iterator().next();
            try {
                gMap.put(uri, wktReader.read(wkt));
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + uri + "...");
            }
        }
        return gMap;
    }

    public static AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold, String relation) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Geometry> sourceMap = RADON.getGeometryMapFromCache(source, properties.get(0));
        Map<String, Geometry> targetMap = RADON.getGeometryMapFromCache(target, properties.get(1));
        return RADON.getMapping(sourceMap, targetMap, relation);
    }

    public static AMapping getMapping(Set<Polygon> sourceData, Set<Polygon> targetData, String relation) {
        HashMap<String, Geometry> source = new HashMap<String, Geometry>();
        HashMap<String, Geometry> target = new HashMap<String, Geometry>();
        for (Polygon polygon : sourceData) {
            try {
                source.put(polygon.uri, polygon.getGeometry());
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + polygon.uri + "...");
            }
        }
        for (Polygon polygon : targetData) {
            try {
                target.put(polygon.uri, polygon.getGeometry());
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + polygon.uri + "...");
            }
        }
        return RADON.getMapping(source, target, relation);
    }

    public static AMapping getMapping(Map<String, Geometry> sourceData, Map<String, Geometry> targetData, String relation) {
        int numThreads = new Double(Math.ceil((double)Runtime.getRuntime().availableProcessors() / 2.0)).intValue();
        String rel = relation;
        boolean disjointStrategy = rel.equals(DISJOINT);
        if (disjointStrategy) {
            rel = INTERSECTS;
        }
        GridSizeHeuristics heuristicsS = new GridSizeHeuristics(sourceData.values());
        GridSizeHeuristics heuristicsT = new GridSizeHeuristics(targetData.values());
        double[] theta = GridSizeHeuristics.decideForTheta(heuristicsS, heuristicsT, heuristicStatMeasure);
        double thetaX = theta[0];
        double thetaY = theta[1];
        boolean swapped = GridSizeHeuristics.swap;
        if (swapped) {
            Map<String, Geometry> swap = sourceData;
            sourceData = targetData;
            targetData = swap;
            switch (rel) {
                case "within": {
                    rel = CONTAINS;
                    break;
                }
                case "contains": {
                    rel = WITHIN;
                    break;
                }
                case "covers": {
                    rel = COVEREDBY;
                    break;
                }
                case "coveredby": {
                    rel = COVERS;
                }
            }
        }
        SquareIndex sourceIndex = RADON.index(sourceData, null, thetaX, thetaY);
        SquareIndex targetIndex = RADON.index(targetData, sourceIndex, thetaX, thetaY);
        ExecutorService matchExec = Executors.newFixedThreadPool(numThreads);
        ExecutorService mergerExec = Executors.newFixedThreadPool(1);
        AMapping m = MappingFactory.createDefaultMapping();
        List<Map<String, Set<String>>> results = Collections.synchronizedList(new ArrayList());
        HashMap computed = new HashMap();
        Matcher matcher = new Matcher(rel, results);
        for (Integer lat : sourceIndex.map.keySet()) {
            for (Integer lon : sourceIndex.map.get(lat).keySet()) {
                List<MBBIndex> source = sourceIndex.getSquare(lat, lon);
                List<MBBIndex> target = targetIndex.getSquare(lat, lon);
                if (target == null || target.size() <= 0) continue;
                for (MBBIndex a : source) {
                    if (!computed.containsKey(a.uri)) {
                        computed.put(a.uri, new HashSet());
                    }
                    for (MBBIndex b : target) {
                        if (((Set)computed.get(a.uri)).contains(b.uri)) continue;
                        ((Set)computed.get(a.uri)).add(b.uri);
                        boolean compute = rel.equals(COVERS) && a.covers(b) || rel.equals(COVEREDBY) && b.covers(a) || rel.equals(CONTAINS) && a.contains(b) || rel.equals(WITHIN) && b.contains(a) || rel.equals(EQUALS) && a.equals(b) || rel.equals(INTERSECTS) || rel.equals(CROSSES) || rel.equals(TOUCHES) || rel.equals(OVERLAPS);
                        if (!compute) continue;
                        if (numThreads == 1) {
                            if (!Matcher.relate(a.polygon, b.polygon, rel).booleanValue()) continue;
                            if (swapped) {
                                m.add(b.origin_uri, a.origin_uri, 1.0);
                                continue;
                            }
                            m.add(a.origin_uri, b.origin_uri, 1.0);
                            continue;
                        }
                        matcher.schedule(a, b);
                        if (matcher.size() != Matcher.maxSize) continue;
                        matchExec.execute(matcher);
                        matcher = new Matcher(rel, results);
                        if (results.size() <= 0) continue;
                        mergerExec.execute(new Merger(results, m));
                    }
                }
            }
        }
        if (numThreads > 1) {
            if (matcher.size() > 0) {
                matchExec.execute(matcher);
            }
            matchExec.shutdown();
            while (!matchExec.isTerminated()) {
                try {
                    if (results.size() > 0) {
                        mergerExec.execute(new Merger(results, m));
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (results.size() > 0) {
                mergerExec.execute(new Merger(results, m));
            }
            mergerExec.shutdown();
            while (!mergerExec.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (disjointStrategy) {
            AMapping disjoint = MappingFactory.createDefaultMapping();
            for (String s : sourceData.keySet()) {
                for (String t : targetData.keySet()) {
                    if (swapped) {
                        if (m.contains(t, s)) continue;
                        disjoint.add(t, s, 1.0);
                        continue;
                    }
                    if (m.contains(s, t)) continue;
                    disjoint.add(s, t, 1.0);
                }
            }
            m = disjoint;
        }
        return m;
    }

    public static SquareIndex index(Map<String, Geometry> input, SquareIndex extIndex, double thetaX, double thetaY) {
        SquareIndex result = new SquareIndex();
        for (String p : input.keySet()) {
            Geometry g = input.get(p);
            Envelope envelope = g.getEnvelopeInternal();
            int minLatIndex = (int)Math.floor(envelope.getMinY() * thetaY);
            int maxLatIndex = (int)Math.ceil(envelope.getMaxY() * thetaY);
            int minLongIndex = (int)Math.floor(envelope.getMinX() * thetaX);
            int maxLongIndex = (int)Math.ceil(envelope.getMaxX() * thetaX);
            if (minLongIndex < (int)Math.floor(-90.0 * thetaX) && maxLongIndex > (int)Math.ceil(90.0 * thetaX)) {
                MBBIndex westernPart = new MBBIndex(minLatIndex, (int)Math.floor(-180.0 * thetaX), maxLatIndex, minLongIndex, g, p + "<}W", p);
                RADON.addToIndex(westernPart, result, extIndex);
                MBBIndex easternPart = new MBBIndex(minLatIndex, maxLongIndex, maxLatIndex, (int)Math.ceil(180.0 * thetaX), g, p + "<}E", p);
                RADON.addToIndex(easternPart, result, extIndex);
                continue;
            }
            MBBIndex mbbIndex = new MBBIndex(minLatIndex, minLongIndex, maxLatIndex, maxLongIndex, g, p);
            RADON.addToIndex(mbbIndex, result, extIndex);
        }
        return result;
    }

    private static void addToIndex(MBBIndex mbbIndex, SquareIndex result, SquareIndex extIndex) {
        if (extIndex == null) {
            for (int latIndex = mbbIndex.lat1; latIndex <= mbbIndex.lat2; ++latIndex) {
                for (int longIndex = mbbIndex.lon1; longIndex <= mbbIndex.lon2; ++longIndex) {
                    result.add(latIndex, longIndex, mbbIndex);
                }
            }
        } else {
            for (int latIndex = mbbIndex.lat1; latIndex <= mbbIndex.lat2; ++latIndex) {
                for (int longIndex = mbbIndex.lon1; longIndex <= mbbIndex.lon2; ++longIndex) {
                    if (extIndex.getSquare(latIndex, longIndex) == null) continue;
                    result.add(latIndex, longIndex, mbbIndex);
                }
            }
        }
    }

    public static class GridSizeHeuristics {
        public static final String AVG = "avg";
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String MED = "median";
        public static boolean swap = false;
        private double size;
        private double minX;
        private double maxX;
        private double avgX;
        private double medX;
        private double minY;
        private double maxY;
        private double avgY;
        private double medY;

        public static double[] decideForTheta(GridSizeHeuristics s, GridSizeHeuristics t, String measure) {
            double[] stats;
            switch (measure) {
                case "max": {
                    stats = new double[]{s.maxX, s.maxY, t.maxX, t.maxY};
                    break;
                }
                case "avg": {
                    stats = new double[]{s.avgX, s.avgY, t.avgX, t.avgY};
                    break;
                }
                case "median": {
                    stats = new double[]{s.medX, s.medY, t.medX, t.medY};
                    break;
                }
                default: {
                    stats = new double[]{s.minX, s.minY, t.minX, t.minY};
                }
            }
            double estAreaS = stats[0] * stats[1] * s.size;
            double estAreaT = stats[2] * stats[3] * t.size;
            swap = estAreaS > estAreaT;
            return new double[]{2.0 / (stats[0] + stats[2]), 2.0 / (stats[1] + stats[3])};
        }

        public GridSizeHeuristics(Collection<Geometry> input) {
            double[] x = new double[input.size()];
            double[] y = new double[input.size()];
            int i = 0;
            for (Geometry geometry : input) {
                Envelope e = geometry.getEnvelopeInternal();
                y[i] = e.getHeight();
                x[i] = e.getWidth();
                ++i;
            }
            this.size = input.size();
            Arrays.sort(x);
            this.minX = x[0];
            this.maxX = x[x.length - 1];
            this.avgX = Arrays.stream(x).average().getAsDouble();
            this.medX = x.length % 2 == 0 ? (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0 : x[x.length / 2];
            Arrays.sort(y);
            this.minY = y[0];
            this.maxY = y[y.length - 1];
            this.avgY = Arrays.stream(y).average().getAsDouble();
            this.medY = y.length % 2 == 0 ? (y[y.length / 2 - 1] + y[y.length / 2]) / 2.0 : y[y.length / 2];
        }

        public double getSize() {
            return this.size;
        }

        public double getMinX() {
            return this.minX;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getAvgX() {
            return this.avgX;
        }

        public double getMedX() {
            return this.medX;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getAvgY() {
            return this.avgY;
        }

        public double getMedY() {
            return this.medY;
        }

        public String toString() {
            DecimalFormat df = new DecimalFormat("0.0000");
            return "[MIN(" + df.format(this.minX) + ";" + df.format(this.minY) + ");MAX(" + df.format(this.maxX) + ";" + df.format(this.maxY) + ";AVG(" + df.format(this.avgX) + ";" + df.format(this.avgY) + ");MED(" + df.format(this.medX) + ";" + df.format(this.medY) + ")]";
        }
    }

    public static class SquareIndex {
        public HashMap<Integer, HashMap<Integer, List<MBBIndex>>> map = new HashMap();

        public SquareIndex() {
        }

        public SquareIndex(int capacity) {
            this.map = new HashMap(capacity);
        }

        public void add(int i, int j, MBBIndex m) {
            if (!this.map.containsKey(i)) {
                this.map.put(i, new HashMap());
            }
            if (!this.map.get(i).containsKey(j)) {
                this.map.get(i).put(j, new ArrayList());
            }
            this.map.get(i).get(j).add(m);
        }

        public List<MBBIndex> getSquare(int i, int j) {
            if (!this.map.containsKey(i) || !this.map.get(i).containsKey(j)) {
                return null;
            }
            return this.map.get(i).get(j);
        }
    }

    public static class Matcher
    implements Runnable {
        public static int maxSize = 1000;
        private String relation;
        private final List<Map<String, Set<String>>> result;
        private List<MBBIndex> scheduled;

        public Matcher(String relation, List<Map<String, Set<String>>> result) {
            this.relation = relation;
            this.result = result;
            this.scheduled = new ArrayList<MBBIndex>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap temp = new HashMap();
            for (int i = 0; i < this.scheduled.size(); i += 2) {
                MBBIndex s = this.scheduled.get(i);
                MBBIndex t = this.scheduled.get(i + 1);
                if (!Matcher.relate(s.polygon, t.polygon, this.relation).booleanValue()) continue;
                if (!temp.containsKey(s.origin_uri)) {
                    temp.put(s.origin_uri, new HashSet());
                }
                ((Set)temp.get(s.origin_uri)).add(t.origin_uri);
            }
            List<Map<String, Set<String>>> list = this.result;
            synchronized (list) {
                this.result.add(temp);
            }
        }

        public void schedule(MBBIndex s, MBBIndex t) {
            this.scheduled.add(s);
            this.scheduled.add(t);
        }

        public int size() {
            return this.scheduled.size();
        }

        private static Boolean relate(Geometry geometry1, Geometry geometry2, String relation) {
            switch (relation) {
                case "equals": {
                    return geometry1.equals(geometry2);
                }
                case "disjoint": {
                    return geometry1.disjoint(geometry2);
                }
                case "intersects": {
                    return geometry1.intersects(geometry2);
                }
                case "touches": {
                    return geometry1.touches(geometry2);
                }
                case "crosses": {
                    return geometry1.crosses(geometry2);
                }
                case "within": {
                    return geometry1.within(geometry2);
                }
                case "contains": {
                    return geometry1.contains(geometry2);
                }
                case "covers": {
                    return geometry1.covers(geometry2);
                }
                case "coveredby": {
                    return geometry1.coveredBy(geometry2);
                }
                case "overlaps": {
                    return geometry1.overlaps(geometry2);
                }
            }
            return geometry1.relate(geometry2, relation);
        }
    }

    public static class MBBIndex {
        public int lat1;
        public int lat2;
        public int lon1;
        public int lon2;
        public Geometry polygon;
        private String uri;
        private String origin_uri;

        public MBBIndex(int lat1, int lon1, int lat2, int lon2, Geometry polygon, String uri) {
            this.lat1 = lat1;
            this.lat2 = lat2;
            this.lon1 = lon1;
            this.lon2 = lon2;
            this.polygon = polygon;
            this.uri = uri;
            this.origin_uri = uri;
        }

        public MBBIndex(int lat1, int lon1, int lat2, int lon2, Geometry polygon, String uri, String origin_uri) {
            this.lat1 = lat1;
            this.lat2 = lat2;
            this.lon1 = lon1;
            this.lon2 = lon2;
            this.polygon = polygon;
            this.uri = uri;
            this.origin_uri = origin_uri;
        }

        public boolean contains(MBBIndex i) {
            return this.lat1 <= i.lat1 && this.lon1 <= i.lon1 && this.lon2 >= i.lon2 && this.lat2 >= i.lat2;
        }

        public boolean covers(MBBIndex i) {
            return this.lat1 <= i.lat1 && this.lon1 <= i.lon1 && this.lon2 >= i.lon2 && this.lat2 >= i.lat2;
        }

        public boolean intersects(MBBIndex i) {
            return !this.disjoint(i);
        }

        public boolean disjoint(MBBIndex i) {
            return this.lat2 < i.lat1 || this.lat1 > i.lat2 || this.lon2 < i.lon1 || this.lon1 > i.lon2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MBBIndex)) {
                return false;
            }
            MBBIndex i = (MBBIndex)o;
            return this.lat1 == i.lat1 && this.lat2 == i.lat2 && this.lon1 == i.lon1 && this.lon2 == i.lon2;
        }
    }

    public static class Merger
    implements Runnable {
        private AMapping m;
        private List<Map<String, Set<String>>> localResults = new ArrayList<Map<String, Set<String>>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Merger(List<Map<String, Set<String>>> results, AMapping m) {
            this.m = m;
            List<Map<String, Set<String>>> list = results;
            synchronized (list) {
                ListIterator<Map<String, Set<String>>> iterator = results.listIterator();
                while (iterator.hasNext()) {
                    this.localResults.add((Map)iterator.next());
                    iterator.remove();
                }
            }
        }

        @Override
        public void run() {
            for (Map<String, Set<String>> result : this.localResults) {
                for (String s : result.keySet()) {
                    for (String t : result.get(s)) {
                        if (GridSizeHeuristics.swap) {
                            this.m.add(t, s, 1.0);
                            continue;
                        }
                        this.m.add(s, t, 1.0);
                    }
                }
            }
        }
    }
}

