/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.mapper.string.triefilter.LengthQuicksort;
import org.aksw.limes.core.measures.mapper.string.triefilter.TrieFilter;
import org.aksw.limes.core.measures.measure.string.RatcliffObershelpMeasure;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatcliffObershelpMapper
extends AMapper {
    static Logger logger = LoggerFactory.getLogger(RatcliffObershelpMapper.class);

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Set<String>> sourceMap = this.getValueToUriMap(source, properties.get(0));
        Map<String, Set<String>> targetMap = this.getValueToUriMap(target, properties.get(1));
        return this.getMapping(sourceMap, targetMap, threshold);
    }

    protected AMapping getMapping(Map<String, Set<String>> sourceMap, Map<String, Set<String>> targetMap, double threshold) {
        ArrayList<String> listA = new ArrayList<String>(sourceMap.keySet());
        ArrayList<String> listB = new ArrayList<String>(targetMap.keySet());
        RatcliffObershelpMeasure metric = new RatcliffObershelpMeasure();
        ConcurrentHashMap<String, Map<String, Double>> similarityBook = new ConcurrentHashMap<String, Map<String, Double>>(listA.size(), 1.0f);
        ArrayList<String> red = listA;
        ArrayList<String> blue = listB;
        LengthQuicksort.sort(red);
        LengthQuicksort.sort(blue);
        boolean swapped = false;
        if (((String)red.get(red.size() - 1)).length() < ((String)blue.get(blue.size() - 1)).length()) {
            ArrayList<String> temp = red;
            red = blue;
            blue = temp;
            swapped = true;
        }
        LinkedList<MutablePair> tempPairs = new LinkedList<MutablePair>();
        if (metric.lengthUpperBound(1, threshold) != -1) {
            LinkedList<ImmutableTriple<Integer, Integer, Integer>> sliceBoundaries = metric.getPartitionBounds(((String)blue.get(blue.size() - 1)).length(), threshold);
            for (ImmutableTriple immutableTriple : sliceBoundaries) {
                MutablePair mutablePair = new MutablePair();
                mutablePair.setLeft(new LinkedList());
                mutablePair.setRight(new LinkedList());
                for (String s : red) {
                    if (s.length() >= (Integer)immutableTriple.getMiddle() && s.length() <= (Integer)immutableTriple.getRight()) {
                        ((List)mutablePair.getLeft()).add(s);
                        continue;
                    }
                    if (s.length() <= (Integer)immutableTriple.getRight()) continue;
                    break;
                }
                for (String s : blue) {
                    if (s.length() == ((Integer)immutableTriple.getLeft()).intValue()) {
                        ((List)mutablePair.getRight()).add(s);
                        continue;
                    }
                    if (s.length() <= (Integer)immutableTriple.getLeft()) continue;
                    break;
                }
                if (((List)mutablePair.getRight()).size() <= 0 || ((List)mutablePair.getLeft()).size() <= 0) continue;
                tempPairs.add(mutablePair);
            }
        } else {
            MutablePair m = new MutablePair();
            m.setLeft(red);
            m.setRight(blue);
            tempPairs.add(m);
        }
        int poolSize = Runtime.getRuntime().availableProcessors();
        if (tempPairs.size() == 0) {
            return MappingFactory.createDefaultMapping();
        }
        poolSize = poolSize > tempPairs.size() ? tempPairs.size() : poolSize;
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        for (Pair pair : tempPairs) {
            TrieFilter worker = new TrieFilter((Pair<List<String>, List<String>>)pair, similarityBook, new RatcliffObershelpMeasure(), threshold);
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.getUriToUriMapping(similarityBook, sourceMap, targetMap, swapped);
    }

    @Override
    public String getName() {
        return "ratcliff-obershelp";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }
}

