/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.string.DoubleMetaphoneMeasure;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class DoubleMetaphoneMapper
extends AMapper {
    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Set<String>> sourceMap = this.getValueToUriMap(source, properties.get(0));
        Map<String, Set<String>> targetMap = this.getValueToUriMap(target, properties.get(1));
        ArrayList<String> listA = new ArrayList<String>(sourceMap.keySet());
        ArrayList<String> listB = new ArrayList<String>(targetMap.keySet());
        Map<String, List<Integer>> invListA = this.getInvertedList(listA);
        Map<String, List<Integer>> invListB = this.getInvertedList(listB);
        ArrayDeque<MutableTriple> similarityBook = new ArrayDeque<MutableTriple>();
        TrieNode trie = TrieNode.recursiveAddAll(invListB);
        for (Map.Entry<String, List<Integer>> entry : invListA.entrySet()) {
            ArrayDeque<TrieSearchState> queue = new ArrayDeque<TrieSearchState>();
            queue.add(new TrieSearchState(0, 0, trie));
            while (!queue.isEmpty()) {
                TrieSearchState current = (TrieSearchState)queue.pop();
                Set<Map.Entry<Character, TrieNode>> childs = current.getNode().getChildren();
                if (childs.isEmpty() && !current.getNode().getReferences().isEmpty()) {
                    similarityBook.push(new MutableTriple((Object)current.getDistance(), entry.getValue(), current.getNode().getReferences()));
                }
                for (Map.Entry entry2 : childs) {
                    if (entry.getKey().length() <= current.getPosition() || !((Character)entry2.getKey()).equals(Character.valueOf(entry.getKey().charAt(current.getPosition())))) continue;
                    queue.push(new TrieSearchState(current.getDistance(), current.getPosition() + 1, (TrieNode)entry2.getValue()));
                }
            }
        }
        AMapping result = MappingFactory.createDefaultMapping();
        while (!similarityBook.isEmpty()) {
            Triple t = (Triple)similarityBook.pop();
            for (Integer i : (List)t.getMiddle()) {
                String a = (String)listA.get(i);
                for (Integer n : (List)t.getRight()) {
                    String b = (String)listB.get(n);
                    int length = a.length();
                    if (a.length() > b.length()) {
                        length = b.length();
                    }
                    for (String sourceUri : sourceMap.get(a)) {
                        for (String targetUri : targetMap.get(b)) {
                            result.add(sourceUri, targetUri, 1.0 - ((Integer)t.getLeft()).doubleValue() / (double)length);
                        }
                    }
                }
            }
        }
        return result;
    }

    private Map<String, List<Integer>> getInvertedList(List<String> list) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(list.size());
        int listASize = list.size();
        for (int i = 0; i < listASize; ++i) {
            String s = list.get(i);
            List<String> code = DoubleMetaphoneMeasure.getCode(s);
            for (String c : code) {
                List<Integer> ref;
                if (!result.containsKey(c)) {
                    ref = new LinkedList();
                    result.put(c, ref);
                } else {
                    ref = (List)result.get(c);
                }
                ref.add(i);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "doubleMetaphone";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    private static class TrieNode {
        private Map<Character, TrieNode> children;
        private List<Integer> references;

        TrieNode(List<Integer> references) {
            this.references = references;
            this.children = new HashMap<Character, TrieNode>();
        }

        static TrieNode recursiveAddAll(Map<String, List<Integer>> code2References) {
            TrieNode root = new TrieNode(null);
            TrieNode.recursiveAddAll(root, code2References);
            return root;
        }

        static void recursiveAddAll(TrieNode root, Map<String, List<Integer>> code2References) {
            for (Map.Entry<String, List<Integer>> entry : code2References.entrySet()) {
                TrieNode.recursiveAdd(root, entry.getKey(), entry.getValue());
            }
        }

        static void recursiveAdd(TrieNode node, String code, List<Integer> references) {
            if (code.length() > 1) {
                TrieNode.recursiveAdd(node.addChild(code.charAt(0), null), code.substring(1), references);
            } else {
                node.addChild(code.charAt(0), references);
            }
        }

        TrieNode addChild(char symbol, List<Integer> references) {
            TrieNode child;
            if (!this.children.containsKey(Character.valueOf(symbol))) {
                child = new TrieNode(references);
                this.children.put(Character.valueOf(symbol), child);
            } else {
                child = this.children.get(Character.valueOf(symbol));
            }
            return child;
        }

        List<Integer> getReferences() {
            return this.references;
        }

        Set<Map.Entry<Character, TrieNode>> getChildren() {
            return this.children.entrySet();
        }
    }

    private static class TrieSearchState {
        private int distance;
        private int position;
        private TrieNode node;

        TrieSearchState(int distance, int position, TrieNode node) {
            this.distance = distance;
            this.position = position;
            this.node = node;
        }

        int getDistance() {
            return this.distance;
        }

        int getPosition() {
            return this.position;
        }

        TrieNode getNode() {
            return this.node;
        }
    }
}

