/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.space.blocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.mapper.space.blocking.IBlockingModule;
import org.aksw.limes.core.measures.measure.space.ISpaceMeasure;
import org.aksw.limes.core.measures.measure.space.SpaceMeasureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HR3Blocker
implements IBlockingModule {
    static Logger logger = LoggerFactory.getLogger(HR3Blocker.class);
    int dim = 2;
    ArrayList<Double> thresholds;
    ArrayList<String> properties;
    ISpaceMeasure measure;
    Instance zero;
    int granularity;
    HashMap<ArrayList<Integer>, ArrayList<ArrayList<Integer>>> cache;

    public HR3Blocker(String props, String measureName, double threshold) {
        this.thresholds = new ArrayList();
        this.properties = new ArrayList();
        String[] split = props.split("\\|");
        this.dim = split.length;
        this.measure = SpaceMeasureFactory.getMeasure(measureName, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.thresholds.add(this.measure.getThreshold(i, threshold));
            this.properties.add(split[i]);
        }
        this.granularity = 2;
        this.cache = new HashMap();
    }

    public HR3Blocker(int granularity, int dimensions) {
        this.granularity = granularity;
        this.dim = dimensions;
    }

    public HR3Blocker(String props, String measureName, double threshold, int _granularity) {
        this.thresholds = new ArrayList();
        this.properties = new ArrayList();
        String[] split = props.split("\\|");
        this.dim = split.length;
        this.measure = SpaceMeasureFactory.getMeasure(measureName, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.thresholds.add(this.measure.getThreshold(i, threshold));
            this.properties.add(split[i]);
        }
        this.granularity = _granularity;
        this.cache = new HashMap();
    }

    public static ArrayList<Double> copyList(ArrayList<Double> list) {
        ArrayList<Double> copy = new ArrayList<Double>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                copy.add(list.get(i));
            }
        }
        return copy;
    }

    public static ArrayList<ArrayList<Double>> addIdsToList(ArrayList<ArrayList<Double>> keys, TreeSet<String> propValues) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        ArrayList<Double> values = new ArrayList<Double>();
        double value = 0.0;
        for (String s : propValues) {
            try {
                value = Double.parseDouble(s);
            }
            catch (Exception e) {
                logger.warn(s + " is not a number. Will be replaced by 0.");
            }
            values.add(value);
        }
        if (keys.size() == 0) {
            for (int j = 0; j < values.size(); ++j) {
                ArrayList<Double> list = new ArrayList<Double>();
                list.add((Double)values.get(j));
                result.add(list);
            }
        } else {
            for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < values.size(); ++j) {
                    ArrayList<Double> copy = HR3Blocker.copyList(keys.get(i));
                    copy.add((Double)values.get(j));
                    result.add(copy);
                }
            }
        }
        return result;
    }

    public void setGranularity(int n) {
        this.granularity = n;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getBlocksToCompare(ArrayList<Integer> blockId) {
        int dim = blockId.size();
        if (dim == 0) {
            return new ArrayList<ArrayList<Integer>>();
        }
        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        ArrayList<ArrayList<Integer>> hr3result = new ArrayList<ArrayList<Integer>>();
        result.add(blockId);
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while ((double)j < Math.pow(2 * this.granularity + 1, i)) {
                int k;
                ArrayList id = (ArrayList)result.get(j);
                ArrayList toAdd = new ArrayList();
                for (k = 0; k < 2 * this.granularity; ++k) {
                    toAdd.add(new ArrayList());
                }
                for (k = 0; k < dim; ++k) {
                    int l;
                    if (k != i) {
                        for (l = 0; l < 2 * this.granularity; ++l) {
                            ((ArrayList)toAdd.get(l)).add((Integer)id.get(k));
                        }
                        continue;
                    }
                    for (l = 0; l < this.granularity; ++l) {
                        ((ArrayList)toAdd.get(l)).add((Integer)id.get(k) - (l + 1));
                    }
                    for (l = 0; l < this.granularity; ++l) {
                        ((ArrayList)toAdd.get(l + this.granularity)).add((Integer)id.get(k) + l + 1);
                    }
                }
                for (int l = 0; l < 2 * this.granularity; ++l) {
                    result.add((ArrayList)toAdd.get(l));
                }
                ++j;
            }
        }
        int alphaPowered = (int)Math.pow(this.granularity, dim);
        for (int i = 0; i < result.size(); ++i) {
            int hr3Index = 0;
            ArrayList block = (ArrayList)result.get(i);
            for (int j = 0; j < dim; ++j) {
                if (block.get(j) == blockId.get(j)) {
                    hr3Index = 0;
                    break;
                }
                int index = Math.abs(blockId.get(j) - (Integer)block.get(j)) - 1;
                hr3Index += (int)Math.pow(index, dim);
            }
            if (hr3Index >= alphaPowered) continue;
            hr3result.add(block);
        }
        return hr3result;
    }

    @Override
    public ArrayList<Integer> getBlockId(Instance a) {
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (int i = 0; i < this.dim; ++i) {
            double value = Double.parseDouble(a.getProperty(this.properties.get(i)).first());
            int blockId = (int)Math.floor((double)this.granularity * value / this.thresholds.get(i));
            blockIds.add(blockId);
        }
        return blockIds;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllBlockIds(Instance a) {
        int i;
        ArrayList<ArrayList<Integer>> blockIds = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Double>> combinations = new ArrayList<ArrayList<Double>>();
        for (i = 0; i < this.dim; ++i) {
            combinations = HR3Blocker.addIdsToList(combinations, a.getProperty(this.properties.get(i)));
        }
        for (i = 0; i < combinations.size(); ++i) {
            ArrayList<Double> combination = combinations.get(i);
            ArrayList<Integer> block = new ArrayList<Integer>();
            for (int j = 0; j < combination.size(); ++j) {
                int blockId = (int)Math.floor((double)this.granularity * combination.get(j) / this.thresholds.get(j));
                block.add(blockId);
            }
            blockIds.add(block);
        }
        return blockIds;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllSourceIds(Instance a, String props) {
        int i;
        String[] sourceProps = props.split("\\|");
        ArrayList<ArrayList<Integer>> blockIds = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Double>> combinations = new ArrayList<ArrayList<Double>>();
        for (i = 0; i < this.dim; ++i) {
            combinations = HR3Blocker.addIdsToList(combinations, a.getProperty(sourceProps[i]));
        }
        for (i = 0; i < combinations.size(); ++i) {
            ArrayList<Double> combination = combinations.get(i);
            ArrayList<Integer> block = new ArrayList<Integer>();
            for (int j = 0; j < combination.size(); ++j) {
                int blockId = (int)Math.floor((double)this.granularity * combination.get(j) / this.thresholds.get(j));
                block.add(blockId);
            }
            blockIds.add(block);
        }
        return blockIds;
    }
}

