/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import org.aksw.limes.core.datastrutures.Point;

public class OrthodromicDistance {
    public static double R = 6371.0;

    public static double getDistanceInDegrees(Point x, Point y) {
        return OrthodromicDistance.getDistanceInDegrees(x.coordinates.get(0), x.coordinates.get(1), y.coordinates.get(0), y.coordinates.get(1));
    }

    public static double getDistanceInDegrees(double lat1, double long1, double lat2, double long2) {
        double la1 = Math.toRadians(lat1);
        double lo1 = Math.toRadians(long1);
        double la2 = Math.toRadians(lat2);
        double lo2 = Math.toRadians(long2);
        return OrthodromicDistance.getDistance(la1, lo1, la2, lo2);
    }

    public static double getDistance(double lat1, double long1, double lat2, double long2) {
        double dLat = lat2 - lat1;
        double dLon = long2 - long1;
        double sinLat = Math.sin(dLat / 2.0);
        double sinLon = Math.sin(dLon / 2.0);
        double a = sinLat * sinLat + sinLon * sinLon * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c;
    }
}

