/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.GeoHR3;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.pointsets.IPointsetsMeasure;
import org.aksw.limes.core.util.LimesWktReader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchidMapper
extends AMapper {
    private static final Logger logger = LoggerFactory.getLogger(OrchidMapper.class);
    IPointsetsMeasure m = null;

    public static List<Point> getPoints(String wktString) {
        LimesWktReader wktReader = new LimesWktReader();
        ArrayList<Point> points = new ArrayList<Point>();
        try {
            Geometry geometry = wktReader.read(wktString);
            for (Coordinate coordinate : geometry.getCoordinates()) {
                points.add(new Point("", Double.isNaN(coordinate.getZ()) ? Lists.newArrayList((Object[])new Double[]{coordinate.getX(), coordinate.getY()}) : Lists.newArrayList((Object[])new Double[]{coordinate.getX(), coordinate.getY(), coordinate.getZ()})));
            }
        }
        catch (ParseException e) {
            logger.warn("Skipping malformed geometry \"" + wktString + "\"...");
        }
        return points;
    }

    public static Polygon getPolygon(String wktString) {
        Polygon p = new Polygon("");
        List<Point> points = OrchidMapper.getPoints(wktString);
        for (Point point : points) {
            p.add(point);
        }
        return p;
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Set<Polygon> sourcePolygons = this.getPolygons(source, properties.get(0));
        Set<Polygon> targetPolygons = this.getPolygons(target, properties.get(1));
        float theta = 1.0f / (float)threshold - 1.0f;
        GeoHR3 orchid = new GeoHR3(theta, GeoHR3.DEFAULT_GRANULARITY, MeasureFactory.getMeasureType(expression));
        return orchid.run(sourcePolygons, targetPolygons);
    }

    public Set<Polygon> getPolygons(ACache c, String property) {
        HashSet<Polygon> polygons = new HashSet<Polygon>();
        for (String uri : c.getAllUris()) {
            TreeSet<String> values = c.getInstance(uri).getProperty(property);
            if (values.size() <= 0) continue;
            String wkt = (String)values.iterator().next();
            polygons.add(new Polygon(uri, OrchidMapper.getPoints(wkt)));
        }
        return polygons;
    }

    @Override
    public String getName() {
        return "Orchid";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 22.0 + 0.005 * (double)(sourceSize + targetSize) - 56.4 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return 0.006 * (double)(sourceSize + targetSize) - 134.2 * threshold;
    }
}

