/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.phonetic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.phoneticmeasure.DoubleMetaphoneMeasure;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class DoubleMetaPhoneMapper
extends AMapper {
    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        String property1 = properties.get(0);
        String property2 = properties.get(1);
        Map<String, Set<String>> sourceMap = this.getValueToUriMap(source, property1);
        Map<String, Set<String>> targetMap = this.getValueToUriMap(target, property2);
        ArrayList<String> listA = new ArrayList<String>(sourceMap.keySet());
        ArrayList<String> listB = new ArrayList<String>(targetMap.keySet());
        Map<String, List<Integer>> invListA = this.getInvertedList(listA);
        Map<String, List<Integer>> invListB = this.getInvertedList(listB);
        ArrayDeque<MutableTriple> similarityBook = new ArrayDeque<MutableTriple>();
        TrieNode trie = TrieNode.recursiveAddAll(invListB);
        int maxDistance = this.getMaxDistance(threshold);
        for (Map.Entry<String, List<Integer>> entry : invListA.entrySet()) {
            ArrayDeque<TrieSearchState> queue = new ArrayDeque<TrieSearchState>();
            queue.add(new TrieSearchState(0, 0, trie));
            while (!queue.isEmpty()) {
                TrieSearchState current = (TrieSearchState)queue.pop();
                Set<Map.Entry<Character, TrieNode>> childs = current.getNode().getChildren();
                if (childs.isEmpty() && !current.getNode().getReferences().isEmpty() && current.getNode().getReferences() != null) {
                    similarityBook.push(new MutableTriple((Object)current.getDistance(), entry.getValue(), current.getNode().getReferences()));
                }
                if (entry.getKey().length() <= current.getPosition()) continue;
                for (Map.Entry entry2 : childs) {
                    if (((Character)entry2.getKey()).equals(Character.valueOf(entry.getKey().charAt(current.getPosition())))) {
                        queue.push(new TrieSearchState(current.getDistance(), current.getPosition() + 1, (TrieNode)entry2.getValue()));
                        continue;
                    }
                    if (current.getDistance() >= maxDistance) continue;
                    queue.push(new TrieSearchState(current.getDistance() + 1, current.getPosition() + 1, (TrieNode)entry2.getValue()));
                }
            }
        }
        AMapping result = MappingFactory.createDefaultMapping();
        while (!similarityBook.isEmpty()) {
            Triple t = (Triple)similarityBook.pop();
            for (Integer i : (List)t.getMiddle()) {
                String a = (String)listA.get(i);
                for (Integer n : (List)t.getRight()) {
                    String b = (String)listB.get(n);
                    for (String sourceUri : sourceMap.get(a)) {
                        for (String targetUri : targetMap.get(b)) {
                            result.add(sourceUri, targetUri, 1.0 - ((Integer)t.getLeft()).doubleValue() / 4.0);
                        }
                    }
                }
            }
        }
        return result;
    }

    private Map<String, List<Integer>> getInvertedList(List<String> list) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(list.size());
        int listASize = list.size();
        for (int i = 0; i < listASize; ++i) {
            List<Integer> ref;
            String s = list.get(i);
            String code = DoubleMetaphoneMeasure.getCode(s);
            if (code == null) continue;
            if (!result.containsKey(code)) {
                ref = new LinkedList();
                result.put(code, ref);
            } else {
                ref = (List)result.get(code);
            }
            ref.add(i);
        }
        return result;
    }

    @Override
    public String getName() {
        return "doublemeta";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    private int getMaxDistance(double threshold) {
        return new Double(Math.floor(4.0 * (1.0 - threshold))).intValue();
    }

    static class TrieNode {
        private Map<Character, TrieNode> children;
        private List<Integer> references;

        public TrieNode(List<Integer> references) {
            this.references = references;
            this.children = new HashMap<Character, TrieNode>();
        }

        public static TrieNode recursiveAddAll(Map<String, List<Integer>> code2References) {
            TrieNode root = new TrieNode(null);
            TrieNode.recursiveAddAll(root, code2References);
            return root;
        }

        public static void recursiveAddAll(TrieNode root, Map<String, List<Integer>> code2References) {
            for (Map.Entry<String, List<Integer>> entry : code2References.entrySet()) {
                TrieNode.recursiveAdd(root, entry.getKey(), entry.getValue());
            }
        }

        private static void recursiveAdd(TrieNode node, String code, List<Integer> references) {
            if (code.length() > 1) {
                TrieNode.recursiveAdd(node.addChild(code.charAt(0), null), code.substring(1), references);
            } else if (code.length() == 1) {
                node.addChild(code.charAt(0), references);
            }
        }

        public TrieNode addChild(char symbol, List<Integer> references) {
            TrieNode child;
            if (!this.children.containsKey(Character.valueOf(symbol))) {
                child = new TrieNode(references);
                this.children.put(Character.valueOf(symbol), child);
            } else {
                child = this.children.get(Character.valueOf(symbol));
            }
            return child;
        }

        public List<Integer> getReferences() {
            return this.references;
        }

        public Set<Map.Entry<Character, TrieNode>> getChildren() {
            return this.children.entrySet();
        }
    }

    static class TrieSearchState {
        private int distance;
        private int position;
        private TrieNode node;

        public TrieSearchState(int distance, int position, TrieNode node) {
            this.distance = distance;
            this.position = position;
            this.node = node;
        }

        public int getDistance() {
            return this.distance;
        }

        public int getPosition() {
            return this.position;
        }

        public TrieNode getNode() {
            return this.node;
        }
    }
}

