/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.IMapper;

public abstract class AMapper
implements IMapper {
    protected Map<String, Set<String>> getValueToUriMap(ACache cache, String property) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ArrayList<String> uris = cache.getAllUris();
        for (String uri : uris) {
            TreeSet<String> values = cache.getInstance(uri).getProperty(property);
            for (String value : values) {
                if (!result.containsKey(value)) {
                    result.put(value, new HashSet());
                }
                ((Set)result.get(value)).add(uri);
            }
        }
        return result;
    }

    protected AMapping getUriToUriMapping(Map<String, Map<String, Double>> valueMap, Map<String, Set<String>> sourceValueToUriMap, Map<String, Set<String>> targetValueToUriMap, boolean swapped) {
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : valueMap.keySet()) {
            for (String t : valueMap.get(s).keySet()) {
                if (sourceValueToUriMap.get(swapped ? t : s) == null) continue;
                for (String sourceUri : sourceValueToUriMap.get(swapped ? t : s)) {
                    for (String targetUri : targetValueToUriMap.get(swapped ? s : t)) {
                        result.add(sourceUri, targetUri, valueMap.get(s).get(t));
                    }
                }
            }
        }
        return result;
    }

    protected AMapping getUriToUriMapping(Map<String, Map<String, Double>> valueMap, Map<String, Set<String>> sourceValueToUriMap, Map<String, Set<String>> targetValueToUriMap) {
        return this.getUriToUriMapping(valueMap, sourceValueToUriMap, targetValueToUriMap, false);
    }

    @Override
    public void setNo(int no) {
    }
}

