/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.serializer;

import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.serializer.NtSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabSeparatedSerializer
extends NtSerializer {
    private static Logger logger = LoggerFactory.getLogger((String)TabSeparatedSerializer.class.getName());
    protected String seperator = "\t";

    @Override
    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add(subject + this.seperator + object + this.seperator + similarity);
    }

    @Override
    public void printStatement(String subject, String predicate, String object, double similarity) {
        try {
            this.writer.println(subject + this.seperator + object + this.seperator + similarity);
        }
        catch (Exception e) {
            logger.warn("Error writing");
        }
    }

    @Override
    public String getName() {
        return "TabSeparatedSerializer";
    }

    @Override
    public void writeToFile(AMapping mapping, String predicate, String file) {
        this.open(file);
        if (mapping.size() > 0) {
            for (String s : mapping.getMap().keySet()) {
                for (String t : mapping.getMap().get(s).keySet()) {
                    this.writer.println("<" + s + ">\t<" + t + ">\t" + mapping.getConfidence(s, t));
                }
            }
        }
        this.close();
    }

    @Override
    public String getFileExtension() {
        return "tsv";
    }

    public String getSeperator() {
        return this.seperator;
    }

    public void setSeperator(String seperator) {
        this.seperator = seperator;
    }
}

