/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.serializer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import org.aksw.limes.core.datastrutures.EvaluationRun;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationSerlializer {
    private static Logger logger = LoggerFactory.getLogger((String)EvaluationSerlializer.class.getName());
    private String extension = "txt";
    private String separator = ",";
    protected PrintWriter writer;
    protected File folder = new File("");
    private final int stringSize = 200;

    private boolean open(String file) {
        try {
            if (!file.contains("/") && !file.contains("\\")) {
                String filePath = this.folder.getAbsolutePath() + File.separatorChar + file;
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            } else {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
        }
        catch (Exception e) {
            logger.warn("Error creating PrintWriter");
            logger.warn(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            logger.warn("Error closing PrintWriter");
            logger.warn(e.getMessage());
            return false;
        }
        return true;
    }

    public void writeToFile(List<EvaluationRun> evaluation, String file) {
        this.open(file);
        if (evaluation.size() > 0) {
            String headers = this.createHeader(evaluation.get(0));
            this.writer.println(headers);
            for (EvaluationRun evaluationRun : evaluation) {
                this.writer.println(evaluationRun.Serialize(this.separator));
            }
        }
        this.close();
    }

    private String createHeader(EvaluationRun evaluationRun) {
        Set<EvaluatorType> headers = evaluationRun.getQualititativeMeasures();
        StringBuilder sb = new StringBuilder(200);
        sb.append("ALGORITHM_NAME");
        sb.append(this.separator);
        sb.append("IMPLEMENTATION_TYPE");
        sb.append(this.separator);
        sb.append("DATASET");
        sb.append(this.separator);
        for (EvaluatorType evaluatorType : headers) {
            sb.append((Object)evaluatorType);
            sb.append(this.separator);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public String getName() {
        return "EvaluationSerializer";
    }

    public String getFileExtension() {
        return this.extension;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
        this.extension = separator.toLowerCase().equals("\t") ? "tsv" : (separator.toLowerCase().equals(",") ? "csv" : "txt");
    }

    public File getFile(String fileName) {
        return new File(this.folder.getAbsolutePath() + File.separatorChar + fileName);
    }

    public void setFolderPath(File folder) {
        this.folder = folder;
    }
}

