/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.util.Iterator;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.ModelRegistry;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryModule
implements IQueryModule {
    protected KBInfo kb;
    private Logger logger = LoggerFactory.getLogger((String)SparqlQueryModule.class.getName());

    public SparqlQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    @Override
    public void fillCache(ACache cache) {
        this.fillCache(cache, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCache(ACache cache, boolean isSparql) {
        long startTime = System.currentTimeMillis();
        String query = this.generateQuery();
        this.logger.info("Querying the endpoint.");
        int offset = 0;
        if (this.kb.getMinOffset() > 0) {
            offset = this.kb.getMinOffset();
        }
        boolean moreResults = false;
        int counter = 0;
        String basicQuery = query;
        do {
            QueryExecution qexec;
            int nextOffset = offset + this.kb.getPageSize();
            if (this.kb.getMaxOffset() > 0) {
                nextOffset = Math.min(this.kb.getMaxOffset(), nextOffset);
            }
            this.logger.info("Getting statements " + offset + " to " + nextOffset);
            if (this.kb.getPageSize() > 0) {
                int limit = this.kb.getPageSize();
                if (this.kb.getMaxOffset() > 0) {
                    limit = nextOffset - offset;
                }
                query = basicQuery + " LIMIT " + limit + " OFFSET " + offset;
            } else {
                query = basicQuery;
                if (this.kb.getMaxOffset() > 0) {
                    query = query + " LIMIT " + this.kb.getMaxOffset();
                }
            }
            Query sparqlQuery = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
            if (!isSparql) {
                Model model = ModelRegistry.getInstance().getMap().get(this.kb.getEndpoint());
                if (model == null) {
                    throw new RuntimeException("No model with id '" + this.kb.getEndpoint() + "' registered");
                }
                qexec = QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            } else {
                qexec = this.kb.getGraph() != null ? QueryExecutionFactory.sparqlService((String)this.kb.getEndpoint(), (Query)sparqlQuery, (String)this.kb.getGraph()) : QueryExecutionFactory.sparqlService((String)this.kb.getEndpoint(), (Query)sparqlQuery);
            }
            ResultSet results = qexec.execSelect();
            try {
                if (results.hasNext()) {
                    moreResults = true;
                } else {
                    moreResults = false;
                    break;
                }
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String value;
                        String uri = soln.get(this.kb.getVar().substring(1)).toString();
                        int i = 1;
                        for (String propertyLabel : this.kb.getProperties()) {
                            if (soln.contains("v" + i)) {
                                value = soln.get("v" + i).toString();
                                cache.addTriple(uri, propertyLabel, value);
                            }
                            ++i;
                        }
                        if (this.kb.getOptionalProperties() != null) {
                            for (String propertyLabel : this.kb.getOptionalProperties()) {
                                if (!soln.contains("v" + i)) continue;
                                value = soln.get("v" + i).toString();
                                cache.addTriple(uri, propertyLabel, value);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Error while processing: " + soln.toString());
                        this.logger.warn("Following exception occurred: " + e.getMessage());
                        e.printStackTrace();
                        throw new RuntimeException();
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception while handling query");
                this.logger.warn(e.toString());
                this.logger.warn("XML = \n" + ResultSetFormatter.asXMLString((ResultSet)results));
            }
            finally {
                qexec.close();
            }
        } while (moreResults && this.kb.getPageSize() > 0 && ((offset += this.kb.getPageSize()) < this.kb.getMaxOffset() || this.kb.getMaxOffset() < 0));
        this.logger.info("Retrieved " + counter + " triples and " + cache.size() + " entities.");
        this.logger.info("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    protected String generateQuery() {
        int i;
        Iterator<String> iter = this.kb.getPrefixes().keySet().iterator();
        String query = "";
        while (iter.hasNext()) {
            String key = iter.next();
            query = query + "PREFIX " + key + ": <" + this.kb.getPrefixes().get(key) + ">\n";
        }
        query = query + "SELECT DISTINCT " + this.kb.getVar();
        int numVars = this.kb.getProperties().size() + (this.kb.getOptionalProperties() == null ? 0 : this.kb.getOptionalProperties().size());
        for (int i2 = 1; i2 <= numVars; ++i2) {
            query = query + " ?v" + i2;
        }
        query = query + "\n";
        if (this.kb.getGraph() != null) {
            if (!this.kb.getGraph().equals(" ") && this.kb.getGraph().length() > 3) {
                this.logger.info("Query Graph: " + this.kb.getGraph());
                query = query + "FROM <" + this.kb.getGraph() + ">\n";
            } else {
                this.kb.setGraph(null);
            }
        }
        if (this.kb.getRestrictions().size() > 0) {
            iter = this.kb.getRestrictions().iterator();
            query = query + "WHERE {\n";
            for (i = 0; i < this.kb.getRestrictions().size(); ++i) {
                String where = this.kb.getRestrictions().get(i).trim();
                if (where.length() <= 3) continue;
                query = query + where + " .\n";
            }
        }
        int varCount = 1;
        i = 1;
        if (this.kb.getProperties().size() > 0) {
            String propertiesStr = "";
            for (String string : this.kb.getProperties()) {
                propertiesStr = propertiesStr + this.kb.getVar() + " " + string + " ?v" + i++ + " .\n";
            }
            while (propertiesStr.contains("/")) {
                propertiesStr = propertiesStr.replaceFirst("/", " ?w" + varCount + " .\n?w" + varCount + " ");
                ++varCount;
            }
            query = query + propertiesStr;
        }
        if (this.kb.getOptionalProperties() != null && this.kb.getOptionalProperties().size() > 0) {
            this.logger.info("Optional properties are " + this.kb.getOptionalProperties());
            String optionalPropertiesStr = "OPTIONAL {\n";
            for (String optionalProperty : this.kb.getOptionalProperties()) {
                optionalPropertiesStr = optionalPropertiesStr + this.kb.getVar() + " " + optionalProperty + " ?v" + i++ + " .\n";
            }
            while (optionalPropertiesStr.contains("/")) {
                optionalPropertiesStr = optionalPropertiesStr.replaceFirst("/", " ?w" + varCount + " .\n?w" + varCount + " ");
                ++varCount;
            }
            query = query + optionalPropertiesStr + "}";
        }
        String[] stringArray = query.split("\n");
        query = "";
        for (int ql = 0; ql < stringArray.length; ++ql) {
            if (stringArray[ql].contains("regex")) {
                query = query + stringArray[ql] + "\n";
                continue;
            }
            if (stringArray[ql].contains("^")) {
                String[] sp = stringArray[ql].replaceAll("\\^", "").split(" ");
                query = query + sp[2] + " " + sp[1] + " " + sp[0] + " " + sp[3] + "\n";
                continue;
            }
            query = query + stringArray[ql] + "\n";
        }
        if (this.kb.getRestrictions().size() > 0) {
            query = query + "}";
        }
        this.logger.info("Query issued is \n" + query);
        return query;
    }
}

