/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.CsvQueryModule;
import org.aksw.limes.core.io.query.FileQueryModule;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.ResilientSparqlQueryModule;
import org.aksw.limes.core.io.query.SparqlQueryModule;
import org.aksw.limes.core.io.query.VectorQueryModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryModuleFactory {
    static Logger logger = LoggerFactory.getLogger((String)QueryModuleFactory.class.getName());

    public static IQueryModule getQueryModule(String name, KBInfo kbinfo) {
        logger.info("Generating <" + name + "> reader");
        if (name.toLowerCase().startsWith("csv")) {
            return new CsvQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("n3") || name.toLowerCase().startsWith("nt")) {
            kbinfo.setType("N3");
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("n-triple")) {
            kbinfo.setType("N-TRIPLE");
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("turtle") || name.toLowerCase().startsWith("ttl")) {
            kbinfo.setType("TURTLE");
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("rdf") || name.toLowerCase().startsWith("xml")) {
            kbinfo.setType("RDF/XML");
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("sparql")) {
            return new SparqlQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("vector")) {
            return new VectorQueryModule(kbinfo);
        }
        return new ResilientSparqlQueryModule(kbinfo);
    }
}

