/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.writer.IMappingWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFMappingWriter
implements IMappingWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)RDFMappingWriter.class.getName());
    public Model mappingModel = ModelFactory.createDefaultModel();

    public static void writeModel(Model model, String format, String outputFile) throws IOException {
        logger.info("Saving dataset to " + outputFile + " ...");
        long starTime = System.currentTimeMillis();
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        model.write((OutputStream)fileOutputStream, format);
        fileOutputStream.close();
        logger.info("Saving file done in " + (System.currentTimeMillis() - starTime) + "ms.");
    }

    @Override
    public void write(AMapping mapping, String outputFile) throws IOException {
        String format;
        switch (format = outputFile.substring(outputFile.indexOf(".") + 1).trim().toLowerCase()) {
            case "n3": 
            case "nt": {
                this.write(mapping, outputFile, "N-TRIPLE");
                break;
            }
            case "ttl": {
                this.write(mapping, outputFile, "TTL");
                break;
            }
            case "rdf": {
                this.write(mapping, outputFile, "RDF/XML");
                break;
            }
            case "jsonld": {
                this.write(mapping, outputFile, "JSON-LD");
                break;
            }
            default: {
                logger.error("Serialization " + format + " is not yet implemented, exit with error!");
                throw new RuntimeException();
            }
        }
    }

    @Override
    public void write(AMapping mapping, String outputFile, String format) throws IOException {
        Property p = ResourceFactory.createProperty((String)mapping.getPredicate());
        for (String source : mapping.getMap().keySet()) {
            for (String target : mapping.getMap().get(source).keySet()) {
                Resource s = ResourceFactory.createResource((String)source);
                Resource o = ResourceFactory.createResource((String)target);
                this.mappingModel.add(s, p, (RDFNode)o);
            }
        }
        RDFMappingWriter.writeModel(this.mappingModel, format, outputFile);
    }
}

