/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping;

import java.util.HashMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.IMapping;
import org.apache.jena.vocabulary.OWL;

public abstract class AMapping
implements IMapping {
    private static final long serialVersionUID = -2139214978237914397L;
    protected HashMap<String, HashMap<String, Double>> map = new HashMap();
    protected HashMap<Double, HashMap<String, TreeSet<String>>> reversedMap = new HashMap();
    protected int size = 0;
    protected String predicate = OWL.sameAs.getURI();

    public abstract double getConfidence(String var1, String var2);

    public abstract void add(String var1, String var2, double var3);

    public abstract void add(String var1, HashMap<String, Double> var2);

    public abstract int size();

    public abstract AMapping reverseSourceTarget();

    public abstract int getNumberofMappings();

    public abstract int getNumberofPositiveMappings();

    public abstract AMapping getOnlyPositiveExamples();

    public abstract boolean contains(String var1, String var2);

    public abstract AMapping getBestOneToNMapping();

    public abstract AMapping getSubMap(double var1);

    public AMapping getBestOneToOneMappings(AMapping m) {
        AMapping m2 = m.getBestOneToNMapping();
        m2 = m2.reverseSourceTarget();
        m2 = m2.getBestOneToNMapping();
        m2 = m2.reverseSourceTarget();
        return m2;
    }

    public HashMap<Double, HashMap<String, TreeSet<String>>> getReversedMap() {
        return this.reversedMap;
    }

    public String getPredicateURI() {
        return this.predicate;
    }

    public HashMap<String, HashMap<String, Double>> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, HashMap<String, Double>> map) {
        this.map = map;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String mappingPredicate) {
        this.predicate = mappingPredicate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        result = 31 * result + (this.reversedMap == null ? 0 : this.reversedMap.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMapping other = (AMapping)obj;
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        if (this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate)) {
            return false;
        }
        if (this.reversedMap == null ? other.reversedMap != null : !this.reversedMap.equals(other.reversedMap)) {
            return false;
        }
        return this.size == other.size;
    }
}

