/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls;

import java.util.ArrayList;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.parser.Parser;

public class ExtendedLinkSpecification
extends LinkSpecification {
    public ExtendedLinkSpecification() {
    }

    public ExtendedLinkSpecification(String measure, double threshold) {
        this.setOperator(null);
        this.setChildren(null);
        this.parent = null;
        this.setDependencies(null);
        this.readSpec(measure, threshold);
    }

    @Override
    public void readSpec(String spec, double theta) {
        Parser p = new Parser(spec = spec.trim(), theta);
        if (p.isAtomic()) {
            this.filterExpression = spec;
            this.setThreshold(theta);
            this.fullExpression = spec;
        } else {
            ExtendedLinkSpecification leftSpec = new ExtendedLinkSpecification();
            ExtendedLinkSpecification rightSpec = new ExtendedLinkSpecification();
            leftSpec.parent = this;
            rightSpec.parent = this;
            this.setChildren(new ArrayList<LinkSpecification>());
            this.getChildren().add(leftSpec);
            this.getChildren().add(rightSpec);
            if (p.getOperator().equalsIgnoreCase("AND")) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase("MIN")) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), theta);
                rightSpec.readSpec(p.getRightTerm(), theta);
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase("OR")) {
                this.setOperator(LogicOperator.OR);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "OR(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase("MAX")) {
                this.setOperator(LogicOperator.OR);
                leftSpec.readSpec(p.getLeftTerm(), theta);
                rightSpec.readSpec(p.getRightTerm(), theta);
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "OR(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase("XOR")) {
                this.setOperator(LogicOperator.MINUS);
                leftSpec.readSpec("OR(" + p.getLeftTerm() + "|" + p.getThreshold1() + "," + p.getRightTerm() + "|" + p.getThreshold2() + ")", theta);
                rightSpec.readSpec("AND(" + p.getLeftTerm() + "|" + p.getThreshold1() + "," + p.getRightTerm() + "|" + p.getThreshold2() + ")", theta);
                this.fullExpression = "MINUS(" + leftSpec.fullExpression + "|" + theta + "," + rightSpec.fullExpression + "|" + theta + ")";
                this.filterExpression = null;
                this.setThreshold(theta);
            } else if (p.getOperator().equalsIgnoreCase("MINUS")) {
                this.setOperator(LogicOperator.MINUS);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "MINUS(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase("ADD")) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), Math.abs(theta - p.getRightCoefficient()) / p.getLeftCoefficient());
                rightSpec.readSpec(p.getRightTerm(), Math.abs(theta - p.getLeftCoefficient()) / p.getRightCoefficient());
                this.filterExpression = spec;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + Math.abs(theta - p.getRightCoefficient()) / p.getLeftCoefficient() + "," + rightSpec.fullExpression + "|" + Math.abs(theta - p.getLeftCoefficient()) / p.getRightCoefficient() + ")";
            }
        }
    }
}

