/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.rdf.LIMES;
import org.aksw.limes.core.io.config.writer.IConfigurationWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFConfigurationWriter
implements IConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)RDFConfigurationWriter.class.getName());

    public static void writeModel(Model model, String format, String outputFile) throws IOException {
        logger.info("Saving dataset to " + outputFile + " ...");
        long starTime = System.currentTimeMillis();
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        model.write((OutputStream)fileOutputStream, format);
        fileOutputStream.close();
        logger.info("Saving file done in " + (System.currentTimeMillis() - starTime) + "ms.");
    }

    @Override
    public void write(Configuration configuration, String outputFile) throws IOException {
        String format;
        switch (format = outputFile.substring(outputFile.indexOf(".") + 1).trim().toLowerCase()) {
            case "n3": 
            case "nt": {
                this.write(configuration, outputFile, "N-TRIPLE");
                break;
            }
            case "ttl": {
                this.write(configuration, outputFile, "TTL");
                break;
            }
            case "rdf": {
                this.write(configuration, outputFile, null);
                break;
            }
            case "jsonld": {
                this.write(configuration, outputFile, "JSON-LD");
                break;
            }
            default: {
                logger.error("Serialization " + format + " is not yet implemented, exit with error!");
                throw new IOException("Serialization " + format + " is not yet implemented!");
            }
        }
    }

    @Override
    public void write(Configuration configuration, String outputFile, String format) throws IOException {
        Model m = ModelFactory.createDefaultModel();
        Resource s = ResourceFactory.createResource();
        m.add(s, RDF.type, (RDFNode)LIMES.LimesSpecs);
        m.setNsPrefixes(configuration.getPrefixes());
        m.setNsPrefix("limes", "http://limes.sf.net/ontology/");
        m.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        m.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        Resource source = ResourceFactory.createResource();
        m.add(s, LIMES.hasSource, (RDFNode)source);
        m.add(source, RDF.type, (RDFNode)LIMES.SourceDataset);
        m.add(source, RDFS.label, configuration.getSourceInfo().getId());
        m.add(source, LIMES.endPoint, (RDFNode)ResourceFactory.createStringLiteral((String)configuration.getSourceInfo().getEndpoint()));
        m.add(source, LIMES.type, String.valueOf(configuration.getSourceInfo().getType()));
        m.add(source, LIMES.variable, configuration.getSourceInfo().getVar());
        m.add(source, LIMES.pageSize, String.valueOf(configuration.getSourceInfo().getPageSize()));
        for (String string : configuration.getSourceInfo().getRestrictions()) {
            m.add(source, LIMES.restriction, string);
        }
        for (String string : configuration.getSourceInfo().getProperties()) {
            m.add(source, LIMES.property, string);
        }
        for (String string : configuration.getSourceInfo().getOptionalProperties()) {
            m.add(source, LIMES.optionalProperty, string);
        }
        for (Map.Entry entry : configuration.getSourceInfo().getFunctions().entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (!((String)entry.getKey()).equals(entry2.getKey()) || !((String)entry2.getValue()).contains(",")) continue;
                m.add(source, LIMES.function, (String)entry2.getValue() + " RENAME " + (String)entry2.getKey());
            }
        }
        Resource target = ResourceFactory.createResource();
        m.add(s, LIMES.hasTarget, (RDFNode)target);
        m.add(target, RDF.type, (RDFNode)LIMES.TargetDataset);
        m.add(target, RDFS.label, configuration.getTargetInfo().getId());
        m.add(target, LIMES.endPoint, (RDFNode)ResourceFactory.createStringLiteral((String)configuration.getTargetInfo().getEndpoint()));
        m.add(target, LIMES.type, String.valueOf(configuration.getTargetInfo().getType()));
        m.add(target, LIMES.variable, configuration.getTargetInfo().getVar() + "");
        m.add(target, LIMES.pageSize, String.valueOf(configuration.getTargetInfo().getPageSize()));
        for (String string : configuration.getTargetInfo().getRestrictions()) {
            m.add(target, LIMES.restriction, string);
        }
        for (String string : configuration.getTargetInfo().getProperties()) {
            m.add(target, LIMES.property, string);
        }
        for (String string : configuration.getTargetInfo().getOptionalProperties()) {
            m.add(target, LIMES.optionalProperty, string);
        }
        for (Map.Entry<String, Map<String, String>> entry : configuration.getTargetInfo().getFunctions().entrySet()) {
            for (Map.Entry<String, String> entry3 : entry.getValue().entrySet()) {
                if (!entry.getKey().equals(entry3.getKey()) || !entry3.getValue().contains(",")) continue;
                m.add(target, LIMES.function, entry3.getValue() + " RENAME " + entry3.getKey());
            }
        }
        Resource resource = ResourceFactory.createResource();
        m.add(s, LIMES.hasMetric, (RDFNode)resource);
        m.add(resource, RDF.type, (RDFNode)LIMES.Metric);
        m.add(resource, LIMES.expression, configuration.getMetricExpression().trim());
        Resource resource2 = ResourceFactory.createResource();
        m.add(s, LIMES.hasAcceptance, (RDFNode)resource2);
        m.add(resource2, RDF.type, (RDFNode)LIMES.Acceptance);
        m.add(resource2, LIMES.threshold, (RDFNode)ResourceFactory.createTypedLiteral((Object)configuration.getAcceptanceThreshold()));
        m.add(resource2, LIMES.file, (RDFNode)ResourceFactory.createStringLiteral((String)configuration.getAcceptanceFile()));
        m.add(resource2, LIMES.relation, (RDFNode)ResourceFactory.createResource((String)configuration.getAcceptanceRelation()));
        Resource resource3 = ResourceFactory.createResource();
        m.add(s, LIMES.hasReview, (RDFNode)resource3);
        m.add(resource3, RDF.type, (RDFNode)LIMES.Review);
        m.add(resource3, LIMES.threshold, (RDFNode)ResourceFactory.createTypedLiteral((Object)configuration.getVerificationThreshold()));
        m.add(resource3, LIMES.file, (RDFNode)ResourceFactory.createStringLiteral((String)configuration.getVerificationFile()));
        m.add(resource3, LIMES.relation, (RDFNode)ResourceFactory.createResource((String)configuration.getVerificationRelation()));
        m.add(s, LIMES.executionPlanner, configuration.getExecutionPlanner());
        m.add(s, LIMES.executionRewriter, configuration.getExecutionRewriter());
        m.add(s, LIMES.executionEngine, configuration.getExecutionEngine());
        m.add(s, LIMES.optimizationTime, String.valueOf(configuration.getOptimizationTime()));
        m.add(s, LIMES.expectedSelectivity, String.valueOf(configuration.getExpectedSelectivity()));
        m.add(s, LIMES.granularity, String.valueOf(configuration.getGranularity()));
        if (configuration.getOutputFormat() != null) {
            m.add(s, LIMES.outputFormat, configuration.getOutputFormat());
        }
        RDFConfigurationWriter.writeModel(m, format, outputFile);
    }
}

