/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine.partialrecallengine.refinement;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.aksw.limes.core.execution.engine.partialrecallengine.refinement.PartialRecallRefinementNode;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.io.ls.LinkSpecification;

public class RuntimeComparison {
    public static int comparePlans(Plan newPlan, Plan bestPlan) {
        return Double.compare(newPlan.getRuntimeCost(), bestPlan.getRuntimeCost());
    }

    public static LinkedList<PartialRecallRefinementNode> sortLinkSpecifications(HashMap<LinkSpecification, Plan> plans) {
        LinkedList<Map.Entry<LinkSpecification, Plan>> temp = new LinkedList<Map.Entry<LinkSpecification, Plan>>(plans.entrySet());
        Collections.sort(temp, new Comparator<Map.Entry<LinkSpecification, Plan>>(){

            @Override
            public int compare(Map.Entry<LinkSpecification, Plan> o1, Map.Entry<LinkSpecification, Plan> o2) {
                Double d2;
                String str1 = o1.getKey().getFullExpression();
                String str2 = o2.getKey().getFullExpression();
                Double d1 = new Double(o1.getValue().getRuntimeCost());
                int com = d1.compareTo(d2 = new Double(o2.getValue().getRuntimeCost()));
                if (com == 0) {
                    return str1.compareTo(str2);
                }
                return d1.compareTo(d2);
            }
        });
        LinkedList<PartialRecallRefinementNode> sortedList = new LinkedList<PartialRecallRefinementNode>();
        for (Map.Entry entry : temp) {
            PartialRecallRefinementNode node = new PartialRecallRefinementNode((LinkSpecification)entry.getKey(), (Plan)entry.getValue());
            sortedList.add(node);
        }
        return sortedList;
    }
}

