/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine.partialrecallengine.refinement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.engine.partialrecallengine.refinement.PartialRecallRefinementNode;
import org.aksw.limes.core.execution.engine.partialrecallengine.refinement.PartialRecallRefinementOperator;
import org.aksw.limes.core.execution.engine.partialrecallengine.refinement.RuntimeComparison;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.execution.planning.planner.LigerPlanner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.apache.log4j.Logger;

public class LigerRefinementOperator
extends PartialRecallRefinementOperator {
    private HashMap<LinkSpecification, Plan> newNodes = new HashMap();
    protected static final Logger logger = Logger.getLogger((String)LigerRefinementOperator.class.getName());

    public HashMap<LinkSpecification, Plan> getNewNodes() {
        return this.newNodes;
    }

    public LigerRefinementOperator(ACache s, ACache t, double recall, long optTime, LinkSpecification spec) {
        super(s, t, recall, optTime, spec);
    }

    @Override
    public void optimize() {
        PartialRecallRefinementNode currentNode;
        long totalOptimizationTime = System.currentTimeMillis() + this.maxOpt;
        while (this.buffer.size() != 0 && System.currentTimeMillis() < totalOptimizationTime && (currentNode = (PartialRecallRefinementNode)this.buffer.poll()) != null) {
            int com;
            LinkSpecification currentLSClone = currentNode.getLinkSpecification().clone();
            Plan currentPlan = currentNode.getPlan();
            LinkSpecification bestLS = this.best.getLinkSpecification();
            Plan bestPlan = this.best.getPlan();
            if (!currentLSClone.toString().equals(bestLS.toString()) && (com = RuntimeComparison.comparePlans(currentPlan, bestPlan)) < 0) {
                this.best.setLinkSpecification(currentLSClone);
                this.best.setPlan(currentPlan);
                int cSel = this.checkSelectivity(this.best.getPlan().getSelectivity());
                if (cSel == 0) break;
            }
            List<LinkSpecification> newLSs = this.refine(currentLSClone);
            this.newNodes = new HashMap();
            this.addSpecifications(newLSs);
            this.total.add(currentLSClone.toString());
            if (this.newNodes.size() == 0) continue;
            LinkedList<PartialRecallRefinementNode> sorted = RuntimeComparison.sortLinkSpecifications(this.newNodes);
            this.buffer.addAll(0, sorted);
        }
    }

    public void addSpecifications(List<LinkSpecification> specs) {
        for (LinkSpecification sp : specs) {
            if (this.total.contains(sp.toString())) continue;
            LigerPlanner planner = new LigerPlanner(this.source, this.target);
            NestedPlan plan = planner.plan(sp);
            int cSel = this.checkSelectivity(plan.getSelectivity());
            if (cSel >= 0) {
                this.newNodes.put(sp, plan);
            }
            this.total.add(sp.toString());
        }
    }

    public List<LinkSpecification> refine(LinkSpecification currentSpec) {
        ArrayList<LinkSpecification> temp = new ArrayList<LinkSpecification>();
        if (currentSpec.isAtomic()) {
            LinkSpecification newLS = this.refineAtomicLinkSpecification(currentSpec);
            if (newLS != null) {
                temp.add(newLS);
            }
        } else {
            List<LinkSpecification> l = this.merge(currentSpec, this.refine(currentSpec.getChildren().get(0)), new ArrayList<LinkSpecification>(Arrays.asList(currentSpec.getChildren().get(1))), true);
            temp.addAll((ArrayList)l);
            List<LinkSpecification> r = null;
            if (!currentSpec.getOperator().equals((Object)LogicOperator.MINUS)) {
                r = this.merge(currentSpec, new ArrayList<LinkSpecification>(Arrays.asList(currentSpec.getChildren().get(0))), this.refine(currentSpec.getChildren().get(1)), false);
                temp.addAll((ArrayList)r);
            }
            if (currentSpec.getOperator().equals((Object)LogicOperator.OR)) {
                LinkSpecification currentSpecCloneL = currentSpec.clone();
                LinkSpecification leftChildClone = currentSpecCloneL.getChildren().get(0);
                if (currentSpecCloneL.getThreshold() > leftChildClone.getThreshold()) {
                    leftChildClone.setThreshold(currentSpecCloneL.getThreshold());
                }
                LinkSpecification currentSpecCloneR = currentSpec.clone();
                LinkSpecification rightChildClone = currentSpecCloneR.getChildren().get(1);
                if (currentSpecCloneR.getThreshold() > rightChildClone.getThreshold()) {
                    rightChildClone.setThreshold(currentSpecCloneR.getThreshold());
                }
                temp.add(leftChildClone);
                temp.add(rightChildClone);
            }
        }
        return temp;
    }

    public LinkSpecification refineAtomicLinkSpecification(LinkSpecification currentSpec) {
        if (!currentSpec.isAtomic()) {
            return null;
        }
        LinkSpecification clone = new LinkSpecification();
        double newThreshold = this.next(currentSpec.getThreshold());
        if (newThreshold == -1.0) {
            clone = null;
        } else {
            clone = currentSpec.clone();
            clone.setThreshold(newThreshold);
        }
        return clone;
    }

    public List<LinkSpecification> merge(LinkSpecification parent, List<LinkSpecification> leftChildren, List<LinkSpecification> rightChildren, boolean isLeft) {
        ArrayList<LinkSpecification> specList = new ArrayList<LinkSpecification>();
        if (isLeft) {
            for (LinkSpecification leftChild : leftChildren) {
                for (LinkSpecification rightChild : rightChildren) {
                    LinkSpecification parentClone = parent.clone();
                    LinkSpecification leftChildClone = leftChild.clone();
                    LinkSpecification rightChildClone = rightChild.clone();
                    parentClone.setChildren(new ArrayList<LinkSpecification>());
                    parentClone.addChild(leftChildClone);
                    leftChildClone.setParent(parentClone);
                    parentClone.addChild(rightChildClone);
                    rightChildClone.setParent(parentClone);
                    specList.add(parentClone);
                }
            }
        } else {
            for (LinkSpecification rightChild : rightChildren) {
                for (LinkSpecification leftChild : leftChildren) {
                    LinkSpecification parentClone = parent.clone();
                    LinkSpecification leftChildClone = leftChild.clone();
                    LinkSpecification rightChildClone = rightChild.clone();
                    parentClone.setChildren(new ArrayList<LinkSpecification>());
                    parentClone.addChild(leftChildClone);
                    leftChildClone.setParent(parentClone);
                    parentClone.addChild(rightChildClone);
                    rightChildClone.setParent(parentClone);
                    specList.add(parentClone);
                }
            }
        }
        return specList;
    }
}

