/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.execution.engine.IExecutionEngine;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionEngine
implements IExecutionEngine {
    static Logger logger = LoggerFactory.getLogger(ExecutionEngine.class);
    protected List<AMapping> buffer;
    protected String sourceVariable;
    protected String targetVariable;
    protected ACache source;
    protected ACache target;
    protected long optimizationTime = 0L;
    protected double expectedSelectivity = 1.0;

    public ExecutionEngine(ACache source, ACache target, String sourceVar, String targetVar) {
        this.setBuffer(new ArrayList<AMapping>());
        this.source = source;
        this.target = target;
        this.sourceVariable = sourceVar;
        this.targetVariable = targetVar;
    }

    public ExecutionEngine(ACache source, ACache target, String sourceVar, String targetVar, long maxOpt, double k) {
        this.setBuffer(new ArrayList<AMapping>());
        this.source = source;
        this.target = target;
        this.sourceVariable = sourceVar;
        this.targetVariable = targetVar;
        if (maxOpt < 0L) {
            logger.info("\nOptimization time cannot be negative. Your input value is " + maxOpt + ".\nSetting it to the default value: 0ms.");
            this.optimizationTime = 0L;
        } else {
            this.optimizationTime = maxOpt;
        }
        if (k < 0.0 || k > 1.0) {
            logger.info("\nExpected selectivity must be between 0.0 and 1.0. Your input value is " + k + ".\nSetting it to the default value: 1.0.");
            this.expectedSelectivity = 1.0;
        } else {
            this.expectedSelectivity = k;
        }
    }

    public List<AMapping> getBuffer() {
        return this.buffer;
    }

    public void setBuffer(List<AMapping> buffer) {
        this.buffer = buffer;
    }
}

