/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.APRF;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accuracy
extends APRF
implements IQualitativeMeasure {
    static Logger logger = LoggerFactory.getLogger(Accuracy.class);

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        double truePositiveValue = Accuracy.trueFalsePositive(predictions, goldStandard.referenceMappings, true);
        long allPositiveValue = goldStandard.referenceMappings.getNumberofPositiveMappings();
        double trueNegativeValue = Accuracy.trueNegative(predictions, goldStandard);
        double falseNegativeValue = Accuracy.falseNegative(predictions, goldStandard.referenceMappings);
        long allNegativeValue = (long)(trueNegativeValue + falseNegativeValue);
        return (truePositiveValue + trueNegativeValue) / (double)(allPositiveValue + allNegativeValue);
    }
}

