/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluator;

import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Accuracy;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Precision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoPrecision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRecall;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefFMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefPrecision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefRecall;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Recall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluatorFactory {
    static Logger logger = LoggerFactory.getLogger(EvaluatorFactory.class);

    public static IQualitativeMeasure create(EvaluatorType measure) {
        if (measure == EvaluatorType.PRECISION) {
            return new Precision();
        }
        if (measure == EvaluatorType.RECALL) {
            return new Recall();
        }
        if (measure == EvaluatorType.F_MEASURE) {
            return new FMeasure();
        }
        if (measure == EvaluatorType.P_PRECISION) {
            return new PseudoPrecision();
        }
        if (measure == EvaluatorType.P_RECALL) {
            return new PseudoRecall();
        }
        if (measure == EvaluatorType.PF_MEASURE) {
            return new PseudoFMeasure();
        }
        if (measure == EvaluatorType.PR_PRECISION) {
            return new PseudoRefPrecision();
        }
        if (measure == EvaluatorType.PR_RECALL) {
            return new PseudoRefRecall();
        }
        if (measure == EvaluatorType.PRF_MEASURE) {
            return new PseudoRefFMeasure();
        }
        if (measure == EvaluatorType.ACCURACY) {
            return new Accuracy();
        }
        return null;
    }
}

