/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.controller.ActiveLearningExamples;
import org.aksw.limes.core.controller.AsynchronousServerOracle;
import org.aksw.limes.core.io.cache.Instance;

class ServerMessage {
    protected boolean success = true;

    ServerMessage() {
    }

    static class UploadMessage
    extends ServerMessage {
        private List<UploadInfo> uploads = new ArrayList<UploadInfo>();

        UploadMessage(Map<String, String> partUploads) {
            for (Map.Entry<String, String> upload : partUploads.entrySet()) {
                this.uploads.add(new UploadInfo(upload.getKey(), upload.getValue()));
            }
        }

        static class UploadInfo {
            private String partName;
            private String uploadId;

            UploadInfo(String partName, String uploadId) {
                this.partName = partName;
                this.uploadId = uploadId;
            }
        }
    }

    static class ScoresMessage {
        private List<Double> exampleScores;

        ScoresMessage(List<Double> exampleScores) {
            this.exampleScores = exampleScores;
        }

        public List<Double> getExampleScores() {
            return this.exampleScores;
        }
    }

    static class ActiveLearningMessage
    extends SubmitMessage {
        private int iteration;
        private List<ExampleInfo> examples = new ArrayList<ExampleInfo>();

        ActiveLearningMessage(String requestId, AsynchronousServerOracle oracle) {
            super(requestId);
            this.iteration = oracle.getIteration();
            if (!oracle.isStopped()) {
                for (ActiveLearningExamples.Example ex : oracle.getExamples()) {
                    this.examples.add(new ExampleInfo(ex.getSource(), ex.getTarget()));
                }
            }
        }

        static class ExampleInfo {
            private String source;
            private String target;
            private List<ExampleInfoContext> sourceContext = new LinkedList<ExampleInfoContext>();
            private List<ExampleInfoContext> targetContext = new LinkedList<ExampleInfoContext>();

            ExampleInfo(Instance source, Instance target) {
                this.source = source.getUri();
                this.target = target.getUri();
                for (String predicate : source.getAllProperties()) {
                    for (String object : source.getProperty(predicate)) {
                        this.sourceContext.add(new ExampleInfoContext(predicate, object));
                    }
                }
                for (String predicate : target.getAllProperties()) {
                    for (String object : target.getProperty(predicate)) {
                        this.targetContext.add(new ExampleInfoContext(predicate, object));
                    }
                }
            }
        }

        static class ExampleInfoContext {
            private String predicate;
            private String object;

            private ExampleInfoContext(String predicate, String object) {
                this.predicate = predicate;
                this.object = object;
            }
        }
    }

    static class SubmitMessage
    extends ServerMessage {
        private String requestId;

        SubmitMessage(String requestId) {
            this.requestId = requestId;
        }
    }

    static class PreprocessingsMessage
    extends ServerMessage {
        private List<PPInfo> availablePreprocessings;

        PreprocessingsMessage(List<PPInfo> availablePreprocessings) {
            this.availablePreprocessings = availablePreprocessings;
        }

        static class PPInfo {
            private String name;
            private int minArgs;
            private int maxArgs;
            private boolean isComplex;

            PPInfo(String name, int minArgs, int maxArgs, boolean isComplex) {
                this.name = name;
                this.minArgs = minArgs;
                this.maxArgs = maxArgs;
                this.isComplex = isComplex;
            }

            public boolean isComplex() {
                return this.isComplex;
            }
        }
    }

    static class OperatorsMessage
    extends ServerMessage {
        private List<String> availableOperators;

        OperatorsMessage(List<String> availableOperators) {
            this.availableOperators = availableOperators;
        }
    }

    static class MeasuresMessage
    extends ServerMessage {
        private List<String> availableMeasures;

        MeasuresMessage(List<String> availableMeasures) {
            this.availableMeasures = availableMeasures;
        }
    }

    static class ResultsMessage
    extends ServerMessage {
        private List<String> availableFiles;

        ResultsMessage(List<String> availableFiles) {
            this.availableFiles = availableFiles;
        }
    }

    static class StatusMessage
    extends ServerMessage {
        private Status status = new Status();

        StatusMessage(int status, String description) {
            this.status.code = status;
            this.status.description = description;
        }

        private static class Status {
            int code;
            String description;

            private Status() {
            }
        }
    }

    static class ErrorMessage
    extends ServerMessage {
        private Error error;

        ErrorMessage(Throwable e) {
            this(-1, e.getMessage());
        }

        ErrorMessage(int code, String message) {
            this.success = false;
            this.error = new Error();
            this.error.code = code;
            this.error.message = message;
        }

        private static class Error {
            private int code;
            private String message;

            private Error() {
            }
        }
    }
}

