/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.aksw.limes.core.controller.ActiveLearningExamples;
import org.aksw.limes.core.controller.ActiveLearningOracle;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;

public class AsynchronousServerOracle
implements ActiveLearningOracle {
    private int iteration = 1;
    private int maxIteration = 10;
    private boolean stopped = false;
    private CompletableFuture<ActiveLearningExamples> activeLearningStarted = new CompletableFuture();
    private CompletableFuture<AMapping> activeLearningFinished = new CompletableFuture();

    AsynchronousServerOracle() {
    }

    AsynchronousServerOracle(int maxIteration) {
        if (maxIteration < 1) {
            maxIteration = 1;
        }
        this.maxIteration = maxIteration;
    }

    @Override
    public AMapping classify(ActiveLearningExamples examples) {
        this.activeLearningStarted.complete(examples);
        this.activeLearningFinished = new CompletableFuture();
        this.activeLearningFinished.thenRun(() -> {
            this.activeLearningStarted = new CompletableFuture();
            if (++this.iteration > this.maxIteration) {
                this.stop();
            }
        });
        return this.activeLearningFinished.join();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.activeLearningStarted.complete(new ActiveLearningExamples(MappingFactory.createDefaultMapping(), new MemoryCache(), new MemoryCache()));
    }

    public ActiveLearningExamples getExamples() {
        return this.activeLearningStarted.join();
    }

    public void completeClassification(List<Double> scores) {
        ActiveLearningExamples examples = this.activeLearningStarted.join();
        Iterator<ActiveLearningExamples.Example> exIt = examples.iterator();
        for (Double score : scores) {
            if (!exIt.hasNext()) continue;
            exIt.next().classify(score);
        }
        this.activeLearningFinished.complete(examples.getExampleMap());
    }
}

