/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching;

import java.util.HashMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.matching.OntologyClassMapper;
import org.aksw.limes.core.ml.algorithm.matching.stablematching.HospitalResidents;
import org.aksw.limes.core.util.Clock;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassMapper
implements OntologyClassMapper {
    public int LIMIT = 300;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    String relation = "http://www.w3.org/2002/07/owl#sameAs";
    Model sourceModel;
    Model targetModel;

    public DefaultClassMapper() {
    }

    public DefaultClassMapper(Model sourceModel, Model targetModel) {
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    public DefaultClassMapper(int limit) {
        this.LIMIT = limit;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    @Override
    public AMapping getEntityMapping(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        AMapping m = this.getMappingClasses(endpoint1, endpoint2, namespace1, namespace2);
        this.logger.debug("Got class mapping " + m);
        HospitalResidents hr = new HospitalResidents();
        m = hr.getMatching(m);
        this.logger.debug("Final class mapping is " + m);
        return m;
    }

    public AMapping getMappingClasses(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        Clock clock = new Clock();
        this.logger.info("Getting mapping from " + namespace1 + " to " + namespace2);
        AMapping m1 = this.getMonoDirectionalMap(endpoint1, endpoint2, namespace1, namespace2);
        this.logger.info("Took " + clock.durationSinceClick() + " ms");
        this.logger.info("Getting mapping from " + namespace2 + " to " + namespace1);
        AMapping m2 = this.getMonoDirectionalMap(endpoint2, endpoint1, namespace2, namespace1);
        this.logger.info("Took " + clock.durationSinceClick() + " ms");
        this.logger.info("Merging the mappings...");
        for (String value : m2.getMap().keySet()) {
            for (String key : m2.getMap().get(value).keySet()) {
                double sim2 = m2.getConfidence(value, key);
                double sim1 = m1.getConfidence(key, value);
                m1.add(key, value, sim1 + sim2);
            }
        }
        if (m1.size() == 0) {
            this.logger.info("No mapping found. Using fallback solution.");
            m1 = this.getMappingClassesFallback(endpoint1, endpoint2, namespace1, namespace2);
        }
        return m1;
    }

    public AMapping getMappingClassesFallback(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        Clock clock = new Clock();
        this.logger.info("Getting mapping from " + namespace1 + " to " + namespace2);
        AMapping m1 = this.getMonoDirectionalMapFallback(endpoint1, endpoint2, namespace1, namespace2);
        this.logger.info("Took " + clock.durationSinceClick() + " ms");
        this.logger.info("Getting mapping from " + namespace2 + " to " + namespace1);
        AMapping m2 = this.getMonoDirectionalMapFallback(endpoint2, endpoint1, namespace2, namespace1);
        this.logger.info("Took " + clock.durationSinceClick() + " ms");
        this.logger.info("Merging the mappings...");
        for (String value : m2.getMap().keySet()) {
            for (String key : m2.getMap().get(value).keySet()) {
                double sim2 = m2.getConfidence(value, key);
                double sim1 = m1.getConfidence(key, value);
                m1.add(key, value, sim1 + sim2);
            }
        }
        return m1;
    }

    public AMapping getMonoDirectionalMap(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        String x;
        HashMap instanceToClassMap = new HashMap();
        HashMap instanceToInstanceMap = new HashMap();
        AMapping classToClassMapping = MappingFactory.createDefaultMapping();
        String query = "SELECT ?x ?a ?b WHERE { ?a <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?x. ?a <" + this.relation + "> ?b. FILTER REGEX(str(?b), \"" + namespace2 + "\") } ";
        if (this.LIMIT > 0) {
            query = query + "LIMIT " + this.LIMIT;
        }
        this.logger.debug("Query from " + namespace1 + " to " + namespace2 + ":\n" + query);
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                x = soln.get("x").toString();
                String a = soln.get("a").toString();
                String b = soln.get("b").toString();
                if (x.equalsIgnoreCase("http://www.w3.org/2002/07/owl#Thing")) continue;
                if (!instanceToClassMap.containsKey(a)) {
                    instanceToClassMap.put(a, new TreeSet());
                }
                ((TreeSet)instanceToClassMap.get(a)).add(x);
                if (!instanceToInstanceMap.containsKey(b)) {
                    instanceToInstanceMap.put(b, new TreeSet());
                }
                ((TreeSet)instanceToInstanceMap.get(b)).add(a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.debug("Got " + instanceToClassMap.size() + " classes");
        for (String bValue : instanceToInstanceMap.keySet()) {
            bValue = bValue.replaceAll(" ", "_");
            query = "SELECT distinct ?x WHERE { <" + bValue + "> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?x }";
            sparqlQuery = QueryFactory.create((String)query);
            qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
            results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                try {
                    x = soln.get("x").toString();
                    for (String instance : (TreeSet)instanceToInstanceMap.get(bValue)) {
                        TreeSet set = (TreeSet)instanceToClassMap.get(instance);
                        for (String clas : set) {
                            if (classToClassMapping.getMap().containsKey(x)) {
                                if (classToClassMapping.getMap().get(x).containsKey(clas)) {
                                    classToClassMapping.getMap().get(x).put(clas, classToClassMapping.getMap().get(x).get(clas) + 1.0);
                                    continue;
                                }
                                classToClassMapping.getMap().get(x).put(clas, 1.0);
                                continue;
                            }
                            classToClassMapping.add(x, clas, 1.0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return classToClassMapping;
    }

    public AMapping getMonoDirectionalMapFallback(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        HashMap classValueMap = new HashMap();
        AMapping classToClass = MappingFactory.createDefaultMapping();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?s ?p ?x ?o \nWHERE { ?s rdf:type ?x . \n?s ?p ?o .\n}";
        if (this.LIMIT > 0) {
            query = query + " LIMIT " + this.LIMIT;
        }
        this.logger.debug("Query:\n" + query);
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                String s = soln.get("s").toString();
                String p = soln.get("p").toString();
                String o = soln.get("o").toString();
                String x = soln.get("x").toString();
                if (!classValueMap.containsKey(x)) {
                    classValueMap.put(x, new TreeSet());
                }
                ((TreeSet)classValueMap.get(x)).add(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String className : classValueMap.keySet()) {
            for (String object : (TreeSet)classValueMap.get(className)) {
                if ((object = object.split("@")[0]).contains("\\") || object.contains("\n") || object.contains("\"")) continue;
                query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?y WHERE { ?s rdf:type ?y . ?s ?p \"" + object + "\"}";
                sparqlQuery = QueryFactory.create((String)query);
                qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
                results = qexec.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String y = soln.get("y").toString();
                        double sim = classToClass.getConfidence(className, y);
                        if (sim > 0.0) {
                            classToClass.getMap().get(className).put(y, sim + 1.0);
                            continue;
                        }
                        classToClass.add(className, y, 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return classToClass;
    }

    public static void main(String[] args) {
        DefaultClassMapper mapper = new DefaultClassMapper();
        AMapping m = mapper.getEntityMapping("http://www.dbpedia.org/sparql", "http://linkedgeodata.org/sparql", "dbpedia", "linkedgeodata");
        System.out.println("Mapping: " + m);
    }

    public static boolean isNumeric(String input) {
        if (input.contains("^^")) {
            input = input.split("^^")[0];
        }
        if (input.contains("%")) {
            input = input.split("\\%")[0];
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

