/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionProblem;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedPreprocessingCommand
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = 4070812489425199490L;
    static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    public Set<String> functions = new HashSet<String>();
    boolean is_mutable = true;
    String command = "lowercase";

    public ChainedPreprocessingCommand(String command, GPConfiguration a_conf) throws InvalidConfigurationException {
        super(a_conf, 1, String.class, ExpressionProblem.ResourceTerminalType.PREPROCESS.intValue(), new int[]{ExpressionProblem.ResourceTerminalType.PREPROCESS.intValue()});
        this.functions.add("lowercase");
        this.functions.add("uppercase");
        this.functions.add("cleaniri");
        this.functions.add("nolang");
        this.command = command;
        this.functions.add(command);
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        if (!this.is_mutable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    public ChainedPreprocessingCommand applyMutation() throws InvalidConfigurationException {
        String[] aO = new String[]{};
        aO = this.functions.toArray(aO);
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        String newOp = aO[randomGen.nextInt(aO.length)];
        ChainedPreprocessingCommand result = new ChainedPreprocessingCommand(newOp, this.getGPConfiguration());
        return result;
    }

    public Object clone() {
        try {
            ChainedPreprocessingCommand result = new ChainedPreprocessingCommand(this.command, this.getGPConfiguration());
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public String toString() {
        return this.command + "->&1";
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        String childPreProc = (String)a_chrom.execute_object(a_n, 0, args);
        if (childPreProc.indexOf(this.command) != -1) {
            return childPreProc;
        }
        for (String complement : this.getComplementFunctions()) {
            if (childPreProc.indexOf(complement) == -1) continue;
            return childPreProc;
        }
        return this.command + "->" + childPreProc;
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    private String[] getComplementFunctions() {
        if (this.command.equals("lowercase")) {
            return new String[]{"uppercase"};
        }
        if (this.command.equals("uppercase")) {
            return new String[]{"lowercase"};
        }
        if (this.command.equals("regularAlphabet")) {
            return new String[]{"cleaniri", "removebraces", "nolang"};
        }
        return new String[0];
    }
}

