/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.dragon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aksw.limes.core.evaluation.evaluationDataLoader.PropMapper;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.execution.engine.SimpleExecutionEngine;
import org.aksw.limes.core.execution.planning.planner.DynamicPlanner;
import org.aksw.limes.core.execution.rewriter.Rewriter;
import org.aksw.limes.core.execution.rewriter.RewriterFactory;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.dragon.DecisionTree;
import org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions.FitnessFunctionDTL;
import org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions.GiniIndex;
import org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions.GlobalFMeasure;
import org.aksw.limes.core.ml.algorithm.dragon.Pruning.ErrorEstimatePruning;
import org.aksw.limes.core.ml.algorithm.dragon.Pruning.GlobalFMeasurePruning;
import org.aksw.limes.core.ml.algorithm.dragon.Pruning.PruningFunctionDTL;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.apache.log4j.Logger;

public class Dragon
extends ACoreMLAlgorithm {
    private static Logger logger = Logger.getLogger(Dragon.class);
    private MLResults mlresult;
    private Configuration configuration;
    public static final String PARAMETER_PRUNING_CONFIDENCE = "confidence threshold for pruning";
    public static final String PARAMETER_PROPERTY_MAPPING = "property mapping";
    public static final String PARAMETER_MAPPING = "initial mapping as training data";
    public static final String PARAMETER_MAX_LINK_SPEC_HEIGHT = "maximum height of the link specification";
    public static final String PARAMETER_MIN_PROPERTY_COVERAGE = "minimum property coverage";
    public static final String PARAMETER_PROPERTY_LEARNING_RATE = "property learning rate";
    public static final String PARAMETER_FITNESS_FUNCTION = "fitness function";
    public static final String PARAMETER_PRUNING_FUNCTION = "pruning function";
    public static final String FITNESS_NAME_GINI_INDEX = "GiniIndex";
    public static final String FITNESS_NAME_GLOBAL_FMEASURE = "GlobalFMeasure";
    public static final String PRUNING_NAME_ERROR_ESTIMATE_PRUNING = "ErrorEstimate";
    public static final String PRUNING_NAME_GLOBAL_FMEASURE = "GlobalFmeasure";
    private static final double pruningConfidence = 0.25;
    private static final int maxLinkSpecHeight = 3;
    private static final double minPropertyCoverage = 0.6;
    private static final double propertyLearningRate = 0.95;
    private static final FitnessFunctionDTL fitnessFunction = new GiniIndex();
    private static final PruningFunctionDTL pruningFunction = new ErrorEstimatePruning();
    private AMapping initialMapping = MappingFactory.createDefaultMapping();
    private AMapping prediction;
    public DecisionTree root;
    private ACache testSourceCache = new MemoryCache();
    private ACache testTargetCache = new MemoryCache();
    private boolean isActive = false;
    public static final String[] stringMeasures = new String[]{"cosine", "jaccard", "jaro", "qgrams", "trigrams"};
    public static final String[] dateMeasures = new String[]{"datesim", "daysim", "yearsim"};
    public static final String[] pointsetMeasures = new String[]{"symmetrichausdorff", "frechet", "hausdorff", "geolink", "geomean", "geolink", "surjection", "fairsurjection"};
    public static final String[] defaultMeasures = new String[]{"jaccard", "trigrams", "cosine", "qgrams"};
    public static final double threshold = 0.01;

    public Dragon() {
        this.setDefaultParameters();
    }

    public Dragon(Configuration c) {
        this.setDefaultParameters();
        this.configuration = c;
    }

    @Override
    public String getName() {
        return "Dragon";
    }

    @Override
    protected MLResults activeLearn() throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Not implemented yet!");
    }

    @Override
    protected MLResults activeLearn(AMapping oracleMapping) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Not implemented yet!");
    }

    @Override
    public AMapping predict(ACache source, ACache target, MLResults mlModel) {
        LinkSpecification ls = mlModel.getLinkSpecification();
        Rewriter rw = RewriterFactory.getDefaultRewriter();
        ls = rw.rewrite(ls);
        DynamicPlanner dp = new DynamicPlanner(source, target);
        SimpleExecutionEngine ee = new SimpleExecutionEngine(source, target, this.configuration.getSourceInfo().getVar(), this.configuration.getTargetInfo().getVar());
        this.prediction = ee.execute(ls, dp);
        return this.prediction;
    }

    @Override
    public void init(List<LearningParameter> lp, ACache sourceCache, ACache targetCache) {
        super.init(lp, sourceCache, targetCache);
        this.prediction = null;
        if (lp == null) {
            this.setDefaultParameters();
        } else {
            this.instantiateFunctionParameters();
        }
    }

    private void instantiateFunctionParameters() {
        if (this.getParameter(PARAMETER_FITNESS_FUNCTION) instanceof String) {
            if (((String)this.getParameter(PARAMETER_FITNESS_FUNCTION)).toLowerCase().equals(FITNESS_NAME_GINI_INDEX.toLowerCase())) {
                this.setParameter(PARAMETER_FITNESS_FUNCTION, new GiniIndex());
            } else if (((String)this.getParameter(PARAMETER_FITNESS_FUNCTION)).toLowerCase().equals(FITNESS_NAME_GLOBAL_FMEASURE.toLowerCase())) {
                this.setParameter(PARAMETER_FITNESS_FUNCTION, new GlobalFMeasure());
            }
        }
        if (this.getParameter(PARAMETER_PRUNING_FUNCTION) instanceof String) {
            if (((String)this.getParameter(PARAMETER_PRUNING_FUNCTION)).toLowerCase().equals(PRUNING_NAME_GLOBAL_FMEASURE.toLowerCase())) {
                this.setParameter(PARAMETER_PRUNING_FUNCTION, new GlobalFMeasurePruning());
            } else if (((String)this.getParameter(PARAMETER_PRUNING_FUNCTION)).toLowerCase().equals(PRUNING_NAME_ERROR_ESTIMATE_PRUNING.toLowerCase())) {
                this.setParameter(PARAMETER_PRUNING_FUNCTION, new ErrorEstimatePruning());
            }
        }
    }

    @Override
    public void setDefaultParameters() {
        this.learningParameters = new ArrayList();
        this.learningParameters.add(new LearningParameter(PARAMETER_PRUNING_CONFIDENCE, 0.25, Double.class, 0.0, 1.0, 0.01, PARAMETER_PRUNING_CONFIDENCE));
        this.learningParameters.add(new LearningParameter(PARAMETER_PROPERTY_MAPPING, new PropertyMapping(), PropertyMapping.class, Double.NaN, Double.NaN, Double.NaN, PARAMETER_PROPERTY_MAPPING));
        this.learningParameters.add(new LearningParameter(PARAMETER_MAPPING, this.initialMapping, AMapping.class, Double.NaN, Double.NaN, Double.NaN, PARAMETER_MAPPING));
        this.learningParameters.add(new LearningParameter(PARAMETER_MAX_LINK_SPEC_HEIGHT, 3, Integer.class, 1.0, 100000.0, 1.0, PARAMETER_MAX_LINK_SPEC_HEIGHT));
        this.learningParameters.add(new LearningParameter(PARAMETER_MIN_PROPERTY_COVERAGE, 0.6, Double.class, 0.0, 1.0, 0.01, PARAMETER_MIN_PROPERTY_COVERAGE));
        this.learningParameters.add(new LearningParameter(PARAMETER_PROPERTY_LEARNING_RATE, 0.95, Double.class, 0.0, 1.0, 0.01, PARAMETER_PROPERTY_LEARNING_RATE));
        this.learningParameters.add(new LearningParameter(PARAMETER_FITNESS_FUNCTION, fitnessFunction, FitnessFunctionDTL.class, new String[]{FITNESS_NAME_GINI_INDEX, FITNESS_NAME_GLOBAL_FMEASURE}, PARAMETER_FITNESS_FUNCTION));
        this.learningParameters.add(new LearningParameter(PARAMETER_PRUNING_FUNCTION, pruningFunction, PruningFunctionDTL.class, new String[]{PRUNING_NAME_ERROR_ESTIMATE_PRUNING, PRUNING_NAME_GLOBAL_FMEASURE}, PARAMETER_FITNESS_FUNCTION));
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Not implemented yet!");
    }

    @Override
    protected boolean supports(MLImplementationType mlType) {
        return mlType == MLImplementationType.SUPERVISED_BATCH;
    }

    private PropertyMapping getPropertyMappingFromParameter() {
        PropertyMapping propertyMapping = null;
        if (this.getParameter(PARAMETER_PROPERTY_MAPPING) instanceof PropertyMapping) {
            propertyMapping = (PropertyMapping)this.getParameter(PARAMETER_PROPERTY_MAPPING);
        } else {
            propertyMapping = PropMapper.getPropertyMappingFromFile(this.getParameter(PARAMETER_PROPERTY_MAPPING).toString());
            this.setParameter(PARAMETER_PROPERTY_MAPPING, propertyMapping);
        }
        return propertyMapping;
    }

    @Override
    protected MLResults learn(AMapping trainingData) throws UnsupportedMLImplementationException {
        this.root = this.isActive ? new DecisionTree(this, this.testSourceCache, this.testTargetCache, null, Double.parseDouble(this.getParameter(PARAMETER_MIN_PROPERTY_COVERAGE).toString()), Double.parseDouble(this.getParameter(PARAMETER_PROPERTY_LEARNING_RATE).toString()), Double.parseDouble(this.getParameter(PARAMETER_PRUNING_CONFIDENCE).toString()), trainingData, this.getPropertyMappingFromParameter()) : new DecisionTree(this, this.sourceCache, this.targetCache, null, (Double)this.getParameter(PARAMETER_MIN_PROPERTY_COVERAGE), (Double)this.getParameter(PARAMETER_PROPERTY_LEARNING_RATE), (Double)this.getParameter(PARAMETER_PRUNING_CONFIDENCE), trainingData, this.getPropertyMappingFromParameter());
        DecisionTree.fitnessFunction = (FitnessFunctionDTL)this.getParameter(PARAMETER_FITNESS_FUNCTION);
        DecisionTree.fitnessFunction.setPropertyMapping((PropertyMapping)this.getParameter(PARAMETER_PROPERTY_MAPPING));
        DecisionTree.pruningFunction = (PruningFunctionDTL)this.getParameter(PARAMETER_PRUNING_FUNCTION);
        DecisionTree.fitnessFunction.setDt(this.root);
        DecisionTree.maxDepth = Integer.parseInt(this.getParameter(PARAMETER_MAX_LINK_SPEC_HEIGHT).toString());
        this.root.buildTree(DecisionTree.maxDepth);
        logger.info((Object)("FULL:\n" + this.root.toString()));
        this.root.prune();
        logger.info((Object)("PRUNED:\n" + this.root.toString()));
        LinkSpecification ls = this.root.getTotalLS();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("tree", this.root);
        MLResults res = new MLResults(ls, null, -1.0, details);
        return res;
    }

    @Override
    public ACache getSourceCache() {
        return this.sourceCache;
    }

    @Override
    public ACache getTargetCache() {
        return this.targetCache;
    }

    public void setSourceCache(ACache sourceCache) {
        this.sourceCache = sourceCache;
    }

    public void setTargetCache(ACache targetCache) {
        this.targetCache = targetCache;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public MLResults getMlresult() {
        return this.mlresult;
    }

    public void setInitialMapping(AMapping initialMapping) {
        this.initialMapping = initialMapping;
    }

    public ACache getTestSourceCache() {
        return this.testSourceCache;
    }

    public ACache getTestTargetCache() {
        return this.testTargetCache;
    }

    @Override
    protected AMapping getNextExamples(int size) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException("Not implemented yet!");
    }

    public class SourceTargetValue {
        String sourceUri;
        String targetUri;
        double value;
        Double compoundMeasureValue = Double.MAX_VALUE;

        public SourceTargetValue(String s, String t, double v) {
            this.sourceUri = s;
            this.targetUri = t;
            this.value = v;
        }

        public SourceTargetValue(String s, String t, double v, Double cmv) {
            this.sourceUri = s;
            this.targetUri = t;
            this.value = v;
            this.compoundMeasureValue = cmv;
        }

        public String toString() {
            return this.sourceUri + " -> " + this.targetUri + " : " + this.value + "     | compound measure value: " + this.compoundMeasureValue;
        }
    }
}

