/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;

public class MLResults {
    protected LinkSpecification linkspec;
    protected AMapping mapping;
    protected double quality;
    protected Map<String, Object> details = new HashMap<String, Object>();
    protected List<SimpleClassifier> classifiers = null;

    public MLResults() {
    }

    public MLResults(LinkSpecification linkspec, AMapping mapping, double quality, Map<String, Object> details) {
        this.linkspec = linkspec;
        this.mapping = mapping;
        this.quality = quality;
        this.details = details;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("RESULT:\n");
        s.append("LS: " + this.linkspec + "\n");
        s.append("Quality: " + this.quality + "\n");
        if (this.mapping != null) {
            s.append("Mapping: " + this.mapping.size() + "\n");
        }
        return s.toString();
    }

    public LinkSpecification getLinkSpecification() {
        return this.linkspec;
    }

    public void setLinkSpecification(LinkSpecification spec) {
        this.linkspec = spec;
    }

    public AMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(AMapping mapping) {
        this.mapping = mapping;
    }

    public double getQuality() {
        return this.quality;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    public void addDetail(String key, Object value) {
        this.details.put(key, value);
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public List<SimpleClassifier> getClassifiers() {
        return this.classifiers;
    }

    public void setClassifiers(List<SimpleClassifier> classifiers) {
        this.classifiers = classifiers;
    }

    public boolean classifiersSet() {
        return this.classifiers != null && this.classifiers.size() > 0;
    }
}

